<?php
/**
 * The template for displaying all pages.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site will use a
 * different template.
 *
 * @package sekhlopress
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

get_header(); ?>

	<div <?php sekhlo_do_attr( 'content' ); ?>>
		<main <?php sekhlo_do_attr( 'main' ); ?>>
			<?php
			/**
			 * sekhlo_before_main_content hook.
			 *
			 * @since 0.1
			 */
			do_action( 'sekhlo_before_main_content' );

			if ( sekhlo_has_default_loop() ) {
				while ( have_posts() ) :

					the_post();

					sekhlo_do_template_part( 'page' );

				endwhile;
			}

			/**
			 * sekhlo_after_main_content hook.
			 *
			 * @since 0.1
			 */
			do_action( 'sekhlo_after_main_content' );
			?>
		</main>
	</div>

	<?php
	/**
	 * sekhlo_after_primary_content_area hook.
	 *
	 * @since 2.0
	 */
	do_action( 'sekhlo_after_primary_content_area' );

	sekhlo_construct_sidebars();

	get_footer();
