<?php
/**
 * Builds our admin page.
 *
 * @package sekhlopress
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'sekhlo_create_menu' ) ) {
	add_action( 'admin_menu', 'sekhlo_create_menu' );
	/**
	 * Adds our "sekhlopress" dashboard menu item
	 *
	 * @since 0.1
	 */
	function sekhlo_create_menu() {
		$sekhlo_page = add_theme_page( esc_html__( 'sekhlopress', 'sekhlopress' ), esc_html__( 'sekhlopress', 'sekhlopress' ), apply_filters( 'sekhlo_dashboard_page_capability', 'edit_theme_options' ), 'generate-options', 'sekhlo_settings_page' );
		add_action( "admin_print_styles-$sekhlo_page", 'sekhlo_options_styles' );
	}
}

if ( ! function_exists( 'sekhlo_options_styles' ) ) {
	/**
	 * Adds any necessary scripts to the GP dashboard page
	 *
	 * @since 0.1
	 */
	function sekhlo_options_styles() {
		wp_enqueue_style( 'generate-options', get_template_directory_uri() . '/assets/css/admin/style.css', array(), SEKHLO_VERSION );
	}
}

if ( ! function_exists( 'sekhlo_settings_page' ) ) {
	/**
	 * Builds the content of our GP dashboard page
	 *
	 * @since 0.1
	 */
	function sekhlo_settings_page() {
		?>
		<div class="wrap">
			<div class="metabox-holder">
				<div class="sp-masthead clearfix">
					<div class="sp-container">
						<div class="sp-title">
							<a href="<?php echo sekhlo_get_premium_url( 'https://www.mubashirhassan.com' ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Escaped in function. ?>" target="_blank">sekhlopress</a> <span class="sp-version"><?php echo esc_html( SEKHLO_VERSION ); ?></span>
						</div>
						<div class="sp-masthead-links">
							<?php if ( ! defined( 'SEKHLO_PREMIUM_VERSION' ) ) : ?>
								<a style="font-weight: bold;" href="<?php echo sekhlo_get_premium_url( 'https://www.mubashirhassan.com/sekhlopress-addon-plugin.html' ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Escaped in function. ?>" target="_blank"><?php esc_html_e( 'Premium', 'sekhlopress' ); ?></a>
							<?php endif; ?>
							<a href="<?php echo esc_url( 'https://www.mubashirhassan.com/' ); ?>" target="_blank"><?php esc_html_e( 'Support', 'sekhlopress' ); ?></a>
							<a href="<?php echo esc_url( 'https://www.mubashirhassan.com' ); ?>" target="_blank"><?php esc_html_e( 'Documentation', 'sekhlopress' ); ?></a>
						</div>
					</div>
				</div>

				<?php
				/**
				 * sekhlo_dashboard_after_header hook.
				 *
				 * @since 2.0
				 */
				do_action( 'sekhlo_dashboard_after_header' );
				?>

				<div class="sp-container">
					<div class="postbox-container clearfix" style="float: none;">
						<div class="grid-container grid-parent">

							<?php
							/**
							 * sekhlo_dashboard_inside_container hook.
							 *
							 * @since 2.0
							 */
							do_action( 'sekhlo_dashboard_inside_container' );
							?>

							<div class="form-metabox grid-70" style="padding-left: 0;">
								<h2 style="height:0;margin:0;"><!-- admin notices below this element --></h2>
								<form method="post" action="options.php">
									<?php settings_fields( 'generate-settings-group' ); ?>
									<?php do_settings_sections( 'generate-settings-group' ); ?>
									<div class="customize-button hide-on-desktop">
										<?php
										printf(
											'<a id="sekhlo_customize_button" class="button button-primary" href="%1$s">%2$s</a>',
											esc_url( admin_url( 'customize.php' ) ),
											esc_html__( 'Customize', 'sekhlopress' )
										);
										?>
									</div>

									<?php
									/**
									 * sekhlo_inside_options_form hook.
									 *
									 * @since 0.1
									 */
									do_action( 'sekhlo_inside_options_form' );
									?>
								</form>

								<?php
								$modules = array(
									'Backgrounds' => array(
										'url' => sekhlo_get_premium_url( 'https://www.mubashirhassan.com/sekhlopress-addon-plugin.html#backgrounds', false ),
									),
									'Blog' => array(
										'url' => sekhlo_get_premium_url( 'https://www.mubashirhassan.com/sekhlopress-addon-plugin.html#blog', false ),
									),
									'Colors' => array(
										'url' => sekhlo_get_premium_url( 'https://www.mubashirhassan.com/sekhlopress-addon-plugin.html#colors', false ),
									),
									'Copyright' => array(
										'url' => sekhlo_get_premium_url( 'https://www.mubashirhassan.com/sekhlopress-addon-plugin.html#copyright', false ),
									),
									'Disable Elements' => array(
										'url' => sekhlo_get_premium_url( 'https://www.mubashirhassan.com/sekhlopress-addon-plugin.html#disable-elements', false ),
									),
									'Elements' => array(
										'url' => sekhlo_get_premium_url( 'https://www.mubashirhassan.com/sekhlopress-addon-plugin.html#elements', false ),
									),
									'Import / Export' => array(
										'url' => sekhlo_get_premium_url( 'https://www.mubashirhassan.com/sekhlopress-addon-plugin.html#import-export', false ),
									),
									'Menu Plus' => array(
										'url' => sekhlo_get_premium_url( 'https://www.mubashirhassan.com/sekhlopress-addon-plugin.html#menu-plus', false ),
									),
									'Secondary Nav' => array(
										'url' => sekhlo_get_premium_url( 'https://www.mubashirhassan.com/sekhlopress-addon-plugin.html#secondary-nav', false ),
									),
									'Sections' => array(
										'url' => sekhlo_get_premium_url( 'https://www.mubashirhassan.com/sekhlopress-addon-plugin.html#sections', false ),
									),
									'Site Library' => array(
										'url' => sekhlo_get_premium_url( 'https://www.mubashirhassan.com/site-library', false ),
									),
									'Spacing' => array(
										'url' => sekhlo_get_premium_url( 'https://www.mubashirhassan.com/sekhlopress-addon-plugin.html#spacing', false ),
									),
									'Typography' => array(
										'url' => sekhlo_get_premium_url( 'https://www.mubashirhassan.com/sekhlopress-addon-plugin.html#typography', false ),
									),
									'WooCommerce' => array(
										'url' => sekhlo_get_premium_url( 'https://www.mubashirhassan.com/sekhlopress-addon-plugin.html#woocommerce', false ),
									),
								);

								if ( ! defined( 'SEKHLO_PREMIUM_VERSION' ) ) :
									?>
									<div class="postbox generate-metabox">
										<h3 class="hndle"><?php esc_html_e( 'Premium Modules', 'sekhlopress' ); ?></h3>
										<div class="inside" style="margin:0;padding:0;">
											<div class="premium-addons">
												<?php
												foreach ( $modules as $module => $info ) {
													?>
													<div class="add-on activated sp-clear addon-container grid-parent">
														<div class="addon-name column-addon-name" style="">
															<a href="<?php echo esc_url( $info['url'] ); ?>" target="_blank"><?php echo esc_html( $module ); ?></a>
														</div>
														<div class="addon-action addon-addon-action" style="text-align:right;">
															<a href="<?php echo esc_url( $info['url'] ); ?>" target="_blank"><?php esc_html_e( 'Learn more', 'sekhlopress' ); ?></a>
														</div>
													</div>
													<div class="sp-clear"></div>
												<?php } ?>
											</div>
										</div>
									</div>
									<?php
								endif;

								/**
								 * sekhlo_options_items hook.
								 *
								 * @since 0.1
								 */
								do_action( 'sekhlo_options_items' );

								$typography_section = 'customize.php?autofocus[section]=font_section';
								$colors_section = 'customize.php?autofocus[section]=body_section';

								if ( function_exists( 'sekhlopress_is_module_active' ) ) {
									if ( sekhlopress_is_module_active( 'sekhlo_package_typography', 'sekhlo_TYPOGRAPHY' ) ) {
										$typography_section = 'customize.php?autofocus[panel]=sekhlo_typography_panel';
									}

									if ( sekhlopress_is_module_active( 'sekhlo_package_colors', 'sekhlo_COLORS' ) ) {
										$colors_section = 'customize.php?autofocus[panel]=sekhlo_colors_panel';
									}
								}

								$quick_settings = array(
									'logo' => array(
										'title' => __( 'Upload Logo', 'sekhlopress' ),
										'icon' => 'dashicons-format-image',
										'url' => admin_url( 'customize.php?autofocus[control]=custom_logo' ),
									),
									'typography' => array(
										'title' => __( 'Customize Fonts', 'sekhlopress' ),
										'icon' => 'dashicons-editor-textcolor',
										'url' => admin_url( $typography_section ),
									),
									'colors' => array(
										'title' => __( 'Customize Colors', 'sekhlopress' ),
										'icon' => 'dashicons-admin-customizer',
										'url' => admin_url( $colors_section ),
									),
									'layout' => array(
										'title' => __( 'Layout Options', 'sekhlopress' ),
										'icon' => 'dashicons-layout',
										'url' => admin_url( 'customize.php?autofocus[panel]=sekhlo_layout_panel' ),
									),
									'all' => array(
										'title' => __( 'All Options', 'sekhlopress' ),
										'icon' => 'dashicons-admin-generic',
										'url' => admin_url( 'customize.php' ),
									),
								);
								?>
							</div>

							<div class="generate-right-sidebar grid-30" style="padding-right: 0;">
								<div class="postbox generate-metabox start-customizing">
									<h3 class="hndle"><?php esc_html_e( 'Start Customizing', 'sekhlopress' ); ?></h3>
									<div class="inside">
										<ul>
											<?php
											foreach ( $quick_settings as $key => $data ) {
												printf(
													'<li><span class="dashicons %1$s"></span> <a href="%2$s">%3$s</a></li>',
													esc_attr( $data['icon'] ),
													esc_url( $data['url'] ),
													esc_html( $data['title'] )
												);
											}
											?>
										</ul>

										<p><?php esc_html_e( 'Want to learn more about the theme? Check out our extensive documentation.', 'sekhlopress' ); ?></p>
										<a href="https://www.mubashirhassan.com"><?php esc_html_e( 'Visit documentation &rarr;', 'sekhlopress' ); ?></a>
									</div>
								</div>

								<?php
								/**
								 * sekhlo_admin_right_panel hook.
								 *
								 * @since 0.1
								 */
								do_action( 'sekhlo_admin_right_panel' );
								?>

								<div class="postbox generate-metabox" id="gen-delete">
									<h3 class="hndle"><?php esc_html_e( 'Reset Settings', 'sekhlopress' ); ?></h3>
									<div class="inside">
										<p><?php esc_html_e( 'Deleting your settings can not be undone.', 'sekhlopress' ); ?></p>
										<form method="post">
											<p><input type="hidden" name="sekhlo_reset_customizer" value="sekhlo_reset_customizer_settings" /></p>
											<p>
												<?php
												$warning = 'return confirm("' . esc_html__( 'Warning: This will delete your settings.', 'sekhlopress' ) . '")';
												wp_nonce_field( 'sekhlo_reset_customizer_nonce', 'sekhlo_reset_customizer_nonce' );

												submit_button(
													esc_attr__( 'Reset', 'sekhlopress' ),
													'button-primary',
													'submit',
													false,
													array(
														'onclick' => esc_js( $warning ),
													)
												);
												?>
											</p>

										</form>
										<?php
										/**
										 * sekhlo_delete_settings_form hook.
										 *
										 * @since 0.1
										 */
										do_action( 'sekhlo_delete_settings_form' );
										?>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="sp-options-footer">
						<span>
							<?php
							printf(
								/* translators: %s: Heart icon */
								_x( 'Made with %s by Tom Usborne', 'made with love', 'sekhlopress' ),
								'<span style="color:#D04848" class="dashicons dashicons-heart"></span>'
							);
							?>
						</span>
					</div>
				</div>
			</div>
		</div>
		<?php
	}
}

if ( ! function_exists( 'sekhlo_reset_customizer_settings' ) ) {
	add_action( 'admin_init', 'sekhlo_reset_customizer_settings' );
	/**
	 * Reset customizer settings
	 *
	 * @since 0.1
	 */
	function sekhlo_reset_customizer_settings() {
		if ( empty( $_POST['sekhlo_reset_customizer'] ) || 'sekhlo_reset_customizer_settings' !== $_POST['sekhlo_reset_customizer'] ) {
			return;
		}

		$nonce = isset( $_POST['sekhlo_reset_customizer_nonce'] ) ? sanitize_key( $_POST['sekhlo_reset_customizer_nonce'] ) : '';

		if ( ! wp_verify_nonce( $nonce, 'sekhlo_reset_customizer_nonce' ) ) {
			return;
		}

		if ( ! current_user_can( 'manage_options' ) ) {
			return;
		}

		delete_option( 'sekhlo_settings' );
		delete_option( 'sekhlo_dynamic_css_output' );
		delete_option( 'sekhlo_dynamic_css_cached_version' );
		remove_theme_mod( 'font_body_variants' );
		remove_theme_mod( 'font_body_category' );

		wp_safe_redirect( admin_url( 'themes.php?page=generate-options&status=reset' ) );
		exit;
	}
}

if ( ! function_exists( 'sekhlo_admin_errors' ) ) {
	add_action( 'admin_notices', 'sekhlo_admin_errors' );
	/**
	 * Add our admin notices
	 *
	 * @since 0.1
	 */
	function sekhlo_admin_errors() {
		$screen = get_current_screen();

		if ( 'appearance_page_generate-options' !== $screen->base ) {
			return;
		}

		if ( isset( $_GET['settings-updated'] ) && 'true' === $_GET['settings-updated'] ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Only checking. False positive.
			add_settings_error( 'generate-notices', 'true', esc_html__( 'Settings saved.', 'sekhlopress' ), 'updated' );
		}

		// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Only checking. False positive.
		if ( isset( $_GET['status'] ) && 'imported' === $_GET['status'] ) {
			add_settings_error( 'generate-notices', 'imported', esc_html__( 'Import successful.', 'sekhlopress' ), 'updated' );
		}

		// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Only checking. False positive.
		if ( isset( $_GET['status'] ) && 'reset' === $_GET['status'] ) {
			add_settings_error( 'generate-notices', 'reset', esc_html__( 'Settings removed.', 'sekhlopress' ), 'updated' );
		}

		settings_errors( 'generate-notices' );
	}
}
