<?php
/**
 * This file handles the customizer fields for the top bar.
 *
 * @package sekhlopress
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // No direct access, please.
}

sekhlopress_Customize_Field::add_title(
	'sekhlo_top_bar_colors_title',
	array(
		'section' => 'sekhlo_colors_section',
		'title' => __( 'Top Bar', 'sekhlopress' ),
		'choices' => array(
			'toggleId' => 'top-bar-colors',
		),
	)
);

sekhlopress_Customize_Field::add_field(
	'sekhlo_settings[top_bar_background_color]',
	'sekhlopress_Customize_Color_Control',
	array(
		'default' => $color_defaults['top_bar_background_color'],
		'transport' => 'postMessage',
		'sanitize_callback' => 'sekhlo_sanitize_rgba_color',
	),
	array(
		'label' => __( 'Background', 'sekhlopress' ),
		'section' => 'sekhlo_colors_section',
		'settings' => 'sekhlo_settings[top_bar_background_color]',
		'active_callback' => 'sekhlo_is_top_bar_active',
		'choices' => array(
			'alpha' => true,
			'toggleId' => 'top-bar-colors',
		),
		'output' => array(
			array(
				'element'  => '.top-bar',
				'property' => 'background-color',
			),
		),
	)
);

sekhlopress_Customize_Field::add_field(
	'sekhlo_settings[top_bar_text_color]',
	'sekhlopress_Customize_Color_Control',
	array(
		'default' => $color_defaults['top_bar_text_color'],
		'transport' => 'postMessage',
		'sanitize_callback' => 'sekhlo_sanitize_rgba_color',
	),
	array(
		'label' => __( 'Text', 'sekhlopress' ),
		'section' => 'sekhlo_colors_section',
		'active_callback' => 'sekhlo_is_top_bar_active',
		'choices' => array(
			'toggleId' => 'top-bar-colors',
		),
		'output' => array(
			array(
				'element'  => '.top-bar',
				'property' => 'color',
			),
		),
	)
);

sekhlopress_Customize_Field::add_wrapper(
	'sekhlo_top_bar_link_wrapper',
	array(
		'section' => 'sekhlo_colors_section',
		'choices' => array(
			'type' => 'color',
			'toggleId' => 'top-bar-colors',
			'items' => array(
				'top_bar_link_color',
				'top_bar_link_color_hover',
			),
		),
	)
);

sekhlopress_Customize_Field::add_field(
	'sekhlo_settings[top_bar_link_color]',
	'sekhlopress_Customize_Color_Control',
	array(
		'default' => $color_defaults['top_bar_link_color'],
		'transport' => 'postMessage',
		'sanitize_callback' => 'sekhlo_sanitize_rgba_color',
	),
	array(
		'label' => __( 'Link', 'sekhlopress' ),
		'section' => 'sekhlo_colors_section',
		'active_callback' => 'sekhlo_is_top_bar_active',
		'choices' => array(
			'wrapper' => 'top_bar_link_color',
			'tooltip' => __( 'Choose Initial Color', 'sekhlopress' ),
			'toggleId' => 'top-bar-colors',
		),
		'output' => array(
			array(
				'element'  => '.top-bar a',
				'property' => 'color',
			),
		),
	)
);

sekhlopress_Customize_Field::add_field(
	'sekhlo_settings[top_bar_link_color_hover]',
	'sekhlopress_Customize_Color_Control',
	array(
		'default' => $color_defaults['top_bar_link_color_hover'],
		'transport' => 'postMessage',
		'sanitize_callback' => 'sekhlo_sanitize_rgba_color',
	),
	array(
		'label' => __( 'Link Hover', 'sekhlopress' ),
		'section' => 'sekhlo_colors_section',
		'active_callback' => 'sekhlo_is_top_bar_active',
		'choices' => array(
			'wrapper' => 'top_bar_link_color_hover',
			'tooltip' => __( 'Choose Hover Color', 'sekhlopress' ),
			'toggleId' => 'top-bar-colors',
			'hideLabel' => true,
		),
		'output' => array(
			array(
				'element'  => '.top-bar a:hover',
				'property' => 'color',
			),
		),
	)
);
