<?php
/**
 * This file handles the customizer fields for the sidebar widgets.
 *
 * @package sekhlopress
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // No direct access, please.
}

sekhlopress_Customize_Field::add_title(
	'sekhlo_sidebar_widgets_colors_title',
	array(
		'section' => 'sekhlo_colors_section',
		'title' => __( 'Sidebar Widgets', 'sekhlopress' ),
		'choices' => array(
			'toggleId' => 'sidebar-widget-colors',
		),
	)
);

sekhlopress_Customize_Field::add_field(
	'sekhlo_settings[sidebar_widget_background_color]',
	'sekhlopress_Customize_Color_Control',
	array(
		'default' => $color_defaults['sidebar_widget_background_color'],
		'sanitize_callback' => 'sekhlo_sanitize_rgba_color',
		'transport' => 'postMessage',
	),
	array(
		'label' => __( 'Background', 'sekhlopress' ),
		'section' => 'sekhlo_colors_section',
		'choices' => array(
			'alpha' => true,
			'toggleId' => 'sidebar-widget-colors',
			'wrapper' => 'sidebar_widget_background_color',
			'tooltip' => __( 'Choose Initial Color', 'sekhlopress' ),
		),
		'output' => array(
			array(
				'element'  => '.sidebar .widget',
				'property' => 'background-color',
			),
		),
	)
);

sekhlopress_Customize_Field::add_field(
	'sekhlo_settings[sidebar_widget_text_color]',
	'sekhlopress_Customize_Color_Control',
	array(
		'default' => $color_defaults['sidebar_widget_text_color'],
		'sanitize_callback' => 'sekhlo_sanitize_hex_color',
		'transport' => 'postMessage',
	),
	array(
		'label' => __( 'Text', 'sekhlopress' ),
		'section' => 'sekhlo_colors_section',
		'choices' => array(
			'toggleId' => 'sidebar-widget-colors',
			'wrapper' => 'sidebar_widget_text_color',
			'tooltip' => __( 'Choose Initial Color', 'sekhlopress' ),
		),
		'output' => array(
			array(
				'element'  => '.sidebar .widget',
				'property' => 'color',
			),
		),
	)
);

sekhlopress_Customize_Field::add_wrapper(
	'sekhlo_sidebar_widget_colors_wrapper',
	array(
		'section' => 'sekhlo_colors_section',
		'choices' => array(
			'type' => 'color',
			'toggleId' => 'sidebar-widget-colors',
			'items' => array(
				'sidebar_widget_link_color',
				'sidebar_widget_link_hover_color',
			),
		),
	)
);

sekhlopress_Customize_Field::add_field(
	'sekhlo_settings[sidebar_widget_link_color]',
	'sekhlopress_Customize_Color_Control',
	array(
		'default' => $color_defaults['sidebar_widget_link_color'],
		'sanitize_callback' => 'sekhlo_sanitize_hex_color',
		'transport' => 'postMessage',
	),
	array(
		'label' => __( 'Link', 'sekhlopress' ),
		'section' => 'sekhlo_colors_section',
		'choices' => array(
			'toggleId' => 'sidebar-widget-colors',
			'wrapper' => 'sidebar_widget_link_color',
			'tooltip' => __( 'Choose Initial Color', 'sekhlopress' ),
		),
		'output' => array(
			array(
				'element'  => '.sidebar .widget a',
				'property' => 'color',
			),
		),
	)
);

sekhlopress_Customize_Field::add_field(
	'sekhlo_settings[sidebar_widget_link_hover_color]',
	'sekhlopress_Customize_Color_Control',
	array(
		'default' => $color_defaults['sidebar_widget_link_hover_color'],
		'sanitize_callback' => 'sekhlo_sanitize_hex_color',
		'transport' => 'postMessage',
	),
	array(
		'label' => __( 'Link Hover', 'sekhlopress' ),
		'section' => 'sekhlo_colors_section',
		'choices' => array(
			'toggleId' => 'sidebar-widget-colors',
			'wrapper' => 'sidebar_widget_link_hover_color',
			'tooltip' => __( 'Choose Hover Color', 'sekhlopress' ),
			'hideLabel' => true,
		),
		'output' => array(
			array(
				'element'  => '.sidebar .widget a:hover',
				'property' => 'color',
			),
		),
	)
);

sekhlopress_Customize_Field::add_field(
	'sekhlo_settings[sidebar_widget_title_color]',
	'sekhlopress_Customize_Color_Control',
	array(
		'default' => $color_defaults['sidebar_widget_title_color'],
		'sanitize_callback' => 'sekhlo_sanitize_hex_color',
		'transport' => 'postMessage',
	),
	array(
		'label' => __( 'Widget Title', 'sekhlopress' ),
		'section' => 'sekhlo_colors_section',
		'choices' => array(
			'toggleId' => 'sidebar-widget-colors',
		),
		'output' => array(
			array(
				'element'  => '.sidebar .widget .widget-title',
				'property' => 'color',
			),
		),
	)
);
