<?php
/**
 * This file handles the customizer fields for the Search Modal.
 *
 * @package sekhlopress
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // No direct access, please.
}

sekhlopress_Customize_Field::add_title(
	'sekhlo_search_modal_colors_title',
	array(
		'section' => 'sekhlo_colors_section',
		'title' => __( 'Search Modal', 'sekhlopress' ),
		'choices' => array(
			'toggleId' => 'search-modal-colors',
		),
		'active_callback' => function() {
			if ( sekhlo_get_option( 'nav_search_modal' ) ) {
				return true;
			}

			return false;
		},
	)
);

sekhlopress_Customize_Field::add_field(
	'sekhlo_settings[search_modal_bg_color]',
	'sekhlopress_Customize_Color_Control',
	array(
		'default' => $color_defaults['search_modal_bg_color'],
		'sanitize_callback' => 'sekhlo_sanitize_rgba_color',
		'transport' => 'postMessage',
	),
	array(
		'label' => __( 'Field Background', 'sekhlopress' ),
		'section' => 'sekhlo_colors_section',
		'choices' => array(
			'toggleId' => 'search-modal-colors',
		),
		'output' => array(
			array(
				'element'  => ':root',
				'property' => '--sp-search-modal-bg-color',
			),
		),
	)
);

sekhlopress_Customize_Field::add_field(
	'sekhlo_settings[search_modal_text_color]',
	'sekhlopress_Customize_Color_Control',
	array(
		'default' => $color_defaults['search_modal_text_color'],
		'sanitize_callback' => 'sekhlo_sanitize_rgba_color',
		'transport' => 'postMessage',
	),
	array(
		'label' => __( 'Field Text', 'sekhlopress' ),
		'section' => 'sekhlo_colors_section',
		'choices' => array(
			'toggleId' => 'search-modal-colors',
		),
		'output' => array(
			array(
				'element'  => ':root',
				'property' => '--sp-search-modal-text-color',
			),
		),
	)
);

sekhlopress_Customize_Field::add_field(
	'sekhlo_settings[search_modal_overlay_bg_color]',
	'sekhlopress_Customize_Color_Control',
	array(
		'default' => $color_defaults['search_modal_overlay_bg_color'],
		'sanitize_callback' => 'sekhlo_sanitize_rgba_color',
		'transport' => 'postMessage',
	),
	array(
		'label' => __( 'Overlay Background', 'sekhlopress' ),
		'section' => 'sekhlo_colors_section',
		'choices' => array(
			'toggleId' => 'search-modal-colors',
		),
		'output' => array(
			array(
				'element'  => ':root',
				'property' => '--sp-search-modal-overlay-bg-color',
			),
		),
	)
);
