<?php
/**
 * This file handles the customizer fields for the primary navigation.
 *
 * @package sekhlopress
 *
 * @var array $color_defaults
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // No direct access, please.
}

$menu_hover_selectors = '.navigation-search input[type="search"], .navigation-search input[type="search"]:active, .navigation-search input[type="search"]:focus, .main-navigation .main-nav ul li:not([class*="current-menu-"]):hover > a, .main-navigation .main-nav ul li:not([class*="current-menu-"]):focus > a, .main-navigation .main-nav ul li.sfHover:not([class*="current-menu-"]) > a, .main-navigation .menu-bar-item:hover > a, .main-navigation .menu-bar-item.sfHover > a';
$menu_current_selectors = '.main-navigation .main-nav ul li[class*="current-menu-"] > a';
$submenu_hover_selectors = '.main-navigation .main-nav ul ul li:not([class*="current-menu-"]):hover > a,.main-navigation .main-nav ul ul li:not([class*="current-menu-"]):focus > a,.main-navigation .main-nav ul ul li.sfHover:not([class*="current-menu-"]) > a';
$submenu_current_selectors = '.main-navigation .main-nav ul ul li[class*="current-menu-"] > a';

sekhlopress_Customize_Field::add_title(
	'sekhlo_primary_navigation_colors_title',
	array(
		'section' => 'sekhlo_colors_section',
		'title' => __( 'Primary Navigation', 'sekhlopress' ),
		'choices' => array(
			'toggleId' => 'primary-navigation-colors',
		),
	)
);

// Navigation background group.
sekhlopress_Customize_Field::add_color_field_group(
	'primary_navigation_background',
	'sekhlo_colors_section',
	'primary-navigation-colors',
	array(
		'sekhlo_settings[navigation_background_color]' => array(
			'default_value' => $color_defaults['navigation_background_color'],
			'label' => __( 'Navigation Background', 'sekhlopress' ),
			'tooltip' => __( 'Choose Initial Color', 'sekhlopress' ),
			'element' => '.main-navigation',
			'property' => 'background-color',
			'hide_label' => false,
		),
		'sekhlo_settings[navigation_background_hover_color]' => array(
			'default_value' => $color_defaults['navigation_background_hover_color'],
			'label' => __( 'Navigation Background Hover', 'sekhlopress' ),
			'tooltip' => __( 'Choose Hover Color', 'sekhlopress' ),
			'element' => $menu_hover_selectors,
			'property' => 'background-color',
			'hide_label' => true,
		),
		'sekhlo_settings[navigation_background_current_color]' => array(
			'default_value' => $color_defaults['navigation_background_current_color'],
			'label' => __( 'Navigation Background Current', 'sekhlopress' ),
			'tooltip' => __( 'Choose Current Color', 'sekhlopress' ),
			'element' => $menu_current_selectors,
			'property' => 'background-color',
			'hide_label' => true,
		),
	)
);

// Navigation text group.
sekhlopress_Customize_Field::add_color_field_group(
	'primary_navigation_text',
	'sekhlo_colors_section',
	'primary-navigation-colors',
	array(
		'sekhlo_settings[navigation_text_color]' => array(
			'default_value' => $color_defaults['navigation_text_color'],
			'label' => __( 'Navigation Text', 'sekhlopress' ),
			'tooltip' => __( 'Choose Initial Color', 'sekhlopress' ),
			'element' => '.main-navigation .main-nav ul li a, .main-navigation .menu-toggle, .main-navigation button.menu-toggle:hover, .main-navigation button.menu-toggle:focus, .main-navigation .mobile-bar-items a, .main-navigation .mobile-bar-items a:hover, .main-navigation .mobile-bar-items a:focus, .main-navigation .menu-bar-items',
			'property' => 'color',
			'hide_label' => false,
		),
		'sekhlo_settings[navigation_text_hover_color]' => array(
			'default_value' => $color_defaults['navigation_text_hover_color'],
			'label' => __( 'Navigation Text Hover', 'sekhlopress' ),
			'tooltip' => __( 'Choose Hover Color', 'sekhlopress' ),
			'element' => $menu_hover_selectors,
			'property' => 'color',
			'hide_label' => true,
		),
		'sekhlo_settings[navigation_text_current_color]' => array(
			'default_value' => $color_defaults['navigation_text_current_color'],
			'label' => __( 'Navigation Text Current', 'sekhlopress' ),
			'tooltip' => __( 'Choose Current Color', 'sekhlopress' ),
			'element' => $menu_current_selectors,
			'property' => 'color',
			'hide_label' => true,
		),
	)
);

// Sub-Menu background group.
sekhlopress_Customize_Field::add_color_field_group(
	'primary_navigation_submenu_background',
	'sekhlo_colors_section',
	'primary-navigation-colors',
	array(
		'sekhlo_settings[subnavigation_background_color]' => array(
			'default_value' => $color_defaults['subnavigation_background_color'],
			'label' => __( 'Sub-Menu Background', 'sekhlopress' ),
			'tooltip' => __( 'Choose Initial Color', 'sekhlopress' ),
			'element' => '.main-navigation ul ul',
			'property' => 'background-color',
			'hide_label' => false,
		),
		'sekhlo_settings[subnavigation_background_hover_color]' => array(
			'default_value' => $color_defaults['subnavigation_background_hover_color'],
			'label' => __( 'Sub-Menu Background Hover', 'sekhlopress' ),
			'tooltip' => __( 'Choose Hover Color', 'sekhlopress' ),
			'element' => $submenu_hover_selectors,
			'property' => 'background-color',
			'hide_label' => true,
		),
		'sekhlo_settings[subnavigation_background_current_color]' => array(
			'default_value' => $color_defaults['subnavigation_background_current_color'],
			'label' => __( 'Sub-Menu Background Current', 'sekhlopress' ),
			'tooltip' => __( 'Choose Current Color', 'sekhlopress' ),
			'element' => $submenu_current_selectors,
			'property' => 'background-color',
			'hide_label' => true,
		),
	)
);

// Sub-Menu text group.
sekhlopress_Customize_Field::add_color_field_group(
	'primary_navigation_submenu_text',
	'sekhlo_colors_section',
	'primary-navigation-colors',
	array(
		'sekhlo_settings[subnavigation_text_color]' => array(
			'default_value' => $color_defaults['subnavigation_text_color'],
			'label' => __( 'Sub-Menu Text', 'sekhlopress' ),
			'tooltip' => __( 'Choose Initial Color', 'sekhlopress' ),
			'element' => '.main-navigation .main-nav ul ul li a',
			'property' => 'color',
			'hide_label' => false,
		),
		'sekhlo_settings[subnavigation_text_hover_color]' => array(
			'default_value' => $color_defaults['subnavigation_text_hover_color'],
			'label' => __( 'Sub-Menu Text Hover', 'sekhlopress' ),
			'tooltip' => __( 'Choose Hover Color', 'sekhlopress' ),
			'element' => $submenu_hover_selectors,
			'property' => 'color',
			'hide_label' => true,
		),
		'sekhlo_settings[subnavigation_text_current_color]' => array(
			'default_value' => $color_defaults['subnavigation_text_current_color'],
			'label' => __( 'Sub-Menu Text Current', 'sekhlopress' ),
			'tooltip' => __( 'Choose Current Color', 'sekhlopress' ),
			'element' => $submenu_current_selectors,
			'property' => 'color',
			'hide_label' => true,
		),
	)
);

sekhlopress_Customize_Field::add_title(
	'sekhlo_navigation_search_colors_title',
	array(
		'section' => 'sekhlo_colors_section',
		'title' => __( 'Navigation Search', 'sekhlopress' ),
		'choices' => array(
			'toggleId' => 'primary-navigation-search-colors',
		),
		'active_callback' => function() {
			if ( 'enable' === sekhlo_get_option( 'nav_search' ) ) {
				return true;
			}

			return false;
		},
	)
);

sekhlopress_Customize_Field::add_field(
	'sekhlo_settings[navigation_search_background_color]',
	'sekhlopress_Customize_Color_Control',
	array(
		'default' => $color_defaults['navigation_search_background_color'],
		'transport' => 'refresh',
		'sanitize_callback' => 'sekhlo_sanitize_rgba_color',
	),
	array(
		'label' => __( 'Background', 'sekhlopress' ),
		'section' => 'sekhlo_colors_section',
		'choices' => array(
			'alpha' => true,
			'toggleId' => 'primary-navigation-search-colors',
		),
	)
);

sekhlopress_Customize_Field::add_field(
	'sekhlo_settings[navigation_search_text_color]',
	'sekhlopress_Customize_Color_Control',
	array(
		'default' => $color_defaults['navigation_search_text_color'],
		'transport' => 'refresh',
		'sanitize_callback' => 'sekhlo_sanitize_rgba_color',
	),
	array(
		'label' => __( 'Text', 'sekhlopress' ),
		'section' => 'sekhlo_colors_section',
		'choices' => array(
			'alpha' => true,
			'toggleId' => 'primary-navigation-search-colors',
		),
	)
);
