<?php
/**
 * This file handles the customizer fields for the header.
 *
 * @package sekhlopress
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // No direct access, please.
}

sekhlopress_Customize_Field::add_title(
	'sekhlo_header_colors_title',
	array(
		'section' => 'sekhlo_colors_section',
		'title' => __( 'Header', 'sekhlopress' ),
		'choices' => array(
			'toggleId' => 'header-colors',
		),
	)
);

sekhlopress_Customize_Field::add_field(
	'sekhlo_settings[header_background_color]',
	'sekhlopress_Customize_Color_Control',
	array(
		'default' => $color_defaults['header_background_color'],
		'transport' => 'postMessage',
		'sanitize_callback' => 'sekhlo_sanitize_rgba_color',
	),
	array(
		'label' => __( 'Background', 'sekhlopress' ),
		'section' => 'sekhlo_colors_section',
		'choices' => array(
			'alpha' => true,
			'toggleId' => 'header-colors',
		),
		'output' => array(
			array(
				'element'  => '.site-header',
				'property' => 'background-color',
			),
		),
	)
);

sekhlopress_Customize_Field::add_field(
	'sekhlo_settings[header_text_color]',
	'sekhlopress_Customize_Color_Control',
	array(
		'default' => $color_defaults['header_text_color'],
		'transport' => 'postMessage',
		'sanitize_callback' => 'sekhlo_sanitize_rgba_color',
	),
	array(
		'label' => __( 'Text', 'sekhlopress' ),
		'section' => 'sekhlo_colors_section',
		'choices' => array(
			'toggleId' => 'header-colors',
		),
		'output' => array(
			array(
				'element'  => '.site-header',
				'property' => 'color',
			),
		),
	)
);

sekhlopress_Customize_Field::add_wrapper(
	'sekhlo_header_link_wrapper',
	array(
		'section' => 'sekhlo_colors_section',
		'choices' => array(
			'type' => 'color',
			'toggleId' => 'header-colors',
			'items' => array(
				'header_link_color',
				'header_link_hover_color',
			),
		),
	)
);

sekhlopress_Customize_Field::add_field(
	'sekhlo_settings[header_link_color]',
	'sekhlopress_Customize_Color_Control',
	array(
		'default' => $color_defaults['header_link_color'],
		'transport' => 'postMessage',
		'sanitize_callback' => 'sekhlo_sanitize_rgba_color',
	),
	array(
		'label' => __( 'Link', 'sekhlopress' ),
		'section' => 'sekhlo_colors_section',
		'choices' => array(
			'toggleId' => 'header-colors',
			'wrapper' => 'header_link_color',
			'tooltip' => __( 'Choose Initial Color', 'sekhlopress' ),
		),
		'output' => array(
			array(
				'element'  => '.site-header a:not([rel="home"])',
				'property' => 'color',
			),
		),
	)
);

sekhlopress_Customize_Field::add_field(
	'sekhlo_settings[header_link_hover_color]',
	'sekhlopress_Customize_Color_Control',
	array(
		'default' => $color_defaults['header_link_hover_color'],
		'transport' => 'postMessage',
		'sanitize_callback' => 'sekhlo_sanitize_rgba_color',
	),
	array(
		'label' => __( 'Link Hover', 'sekhlopress' ),
		'section' => 'sekhlo_colors_section',
		'choices' => array(
			'toggleId' => 'header-colors',
			'wrapper' => 'header_link_hover_color',
			'tooltip' => __( 'Choose Hover Color', 'sekhlopress' ),
			'hideLabel' => true,
		),
		'output' => array(
			array(
				'element'  => '.site-header a:not([rel="home"]):hover',
				'property' => 'color',
			),
		),
	)
);

sekhlopress_Customize_Field::add_field(
	'sekhlo_settings[site_title_color]',
	'sekhlopress_Customize_Color_Control',
	array(
		'default' => $color_defaults['site_title_color'],
		'transport' => 'postMessage',
		'sanitize_callback' => 'sekhlo_sanitize_rgba_color',
	),
	array(
		'label' => __( 'Site Title', 'sekhlopress' ),
		'section' => 'sekhlo_colors_section',
		'choices' => array(
			'toggleId' => 'header-colors',
		),
		'output' => array(
			array(
				'element'  => '.main-title a, .main-title a:hover',
				'property' => 'color',
			),
		),
	)
);

sekhlopress_Customize_Field::add_field(
	'sekhlo_settings[site_tagline_color]',
	'sekhlopress_Customize_Color_Control',
	array(
		'default' => $color_defaults['site_tagline_color'],
		'transport' => 'postMessage',
		'sanitize_callback' => 'sekhlo_sanitize_rgba_color',
	),
	array(
		'label' => __( 'Tagline', 'sekhlopress' ),
		'section' => 'sekhlo_colors_section',
		'choices' => array(
			'toggleId' => 'header-colors',
		),
		'output' => array(
			array(
				'element'  => '.site-description',
				'property' => 'color',
			),
		),
	)
);
