<?php
/**
 * This file handles the customizer fields for the footer bar.
 *
 * @package sekhlopress
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // No direct access, please.
}

sekhlopress_Customize_Field::add_title(
	'sekhlo_footer_bar_colors_title',
	array(
		'section' => 'sekhlo_colors_section',
		'title' => __( 'Footer Bar', 'sekhlopress' ),
		'choices' => array(
			'toggleId' => 'footer-bar-colors',
		),
	)
);

sekhlopress_Customize_Field::add_field(
	'sekhlo_settings[footer_background_color]',
	'sekhlopress_Customize_Color_Control',
	array(
		'default' => $color_defaults['footer_background_color'],
		'sanitize_callback' => 'sekhlo_sanitize_rgba_color',
		'transport' => 'postMessage',
	),
	array(
		'label' => __( 'Background', 'sekhlopress' ),
		'section' => 'sekhlo_colors_section',
		'choices' => array(
			'alpha' => true,
			'toggleId' => 'footer-bar-colors',
			'wrapper' => 'footer_background_color',
			'tooltip' => __( 'Choose Initial Color', 'sekhlopress' ),
		),
		'output' => array(
			array(
				'element'  => '.site-info',
				'property' => 'background-color',
			),
		),
	)
);

sekhlopress_Customize_Field::add_field(
	'sekhlo_settings[footer_text_color]',
	'sekhlopress_Customize_Color_Control',
	array(
		'default' => $color_defaults['footer_text_color'],
		'sanitize_callback' => 'sekhlo_sanitize_hex_color',
		'transport' => 'postMessage',
	),
	array(
		'label' => __( 'Text', 'sekhlopress' ),
		'section' => 'sekhlo_colors_section',
		'choices' => array(
			'toggleId' => 'footer-bar-colors',
			'wrapper' => 'footer_text_color',
			'tooltip' => __( 'Choose Initial Color', 'sekhlopress' ),
		),
		'output' => array(
			array(
				'element'  => '.site-info',
				'property' => 'color',
			),
		),
	)
);

sekhlopress_Customize_Field::add_wrapper(
	'sekhlo_footer_bar_colors_wrapper',
	array(
		'section' => 'sekhlo_colors_section',
		'choices' => array(
			'type' => 'color',
			'toggleId' => 'footer-bar-colors',
			'items' => array(
				'footer_link_color',
				'footer_link_hover_color',
			),
		),
	)
);

sekhlopress_Customize_Field::add_field(
	'sekhlo_settings[footer_link_color]',
	'sekhlopress_Customize_Color_Control',
	array(
		'default' => $color_defaults['footer_link_color'],
		'sanitize_callback' => 'sekhlo_sanitize_hex_color',
		'transport' => 'postMessage',
	),
	array(
		'label' => __( 'Link', 'sekhlopress' ),
		'section' => 'sekhlo_colors_section',
		'choices' => array(
			'toggleId' => 'footer-bar-colors',
			'wrapper' => 'footer_link_color',
			'tooltip' => __( 'Choose Initial Color', 'sekhlopress' ),
		),
		'output' => array(
			array(
				'element'  => '.site-info a',
				'property' => 'color',
			),
		),
	)
);

sekhlopress_Customize_Field::add_field(
	'sekhlo_settings[footer_link_hover_color]',
	'sekhlopress_Customize_Color_Control',
	array(
		'default' => $color_defaults['footer_link_hover_color'],
		'sanitize_callback' => 'sekhlo_sanitize_hex_color',
		'transport' => 'postMessage',
	),
	array(
		'label' => __( 'Link Hover', 'sekhlopress' ),
		'section' => 'sekhlo_colors_section',
		'choices' => array(
			'toggleId' => 'footer-bar-colors',
			'wrapper' => 'footer_link_hover_color',
			'tooltip' => __( 'Choose Hover Color', 'sekhlopress' ),
			'hideLabel' => true,
		),
		'output' => array(
			array(
				'element'  => '.site-info a:hover',
				'property' => 'color',
			),
		),
	)
);
