<?php
/**
 * This file handles the customizer fields for the Body.
 *
 * @package sekhlopress
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // No direct access, please.
}

sekhlopress_Customize_Field::add_title(
	'sekhlo_buttons_colors_title',
	array(
		'section' => 'sekhlo_colors_section',
		'title' => __( 'Buttons', 'sekhlopress' ),
		'choices' => array(
			'toggleId' => 'button-colors',
		),
	)
);

sekhlopress_Customize_Field::add_wrapper(
	'sekhlo_buttons_background_wrapper',
	array(
		'section' => 'sekhlo_colors_section',
		'choices' => array(
			'type' => 'color',
			'toggleId' => 'button-colors',
			'items' => array(
				'form_button_background_color',
				'form_button_background_color_hover',
			),
		),
	)
);

$buttons_selector = 'button, html input[type="button"], input[type="reset"], input[type="submit"], a.button, a.button:visited, a.wp-block-button__link:not(.has-background)';
$buttons_hover_selector = 'button:hover, html input[type="button"]:hover, input[type="reset"]:hover, input[type="submit"]:hover, a.button:hover, button:focus, html input[type="button"]:focus, input[type="reset"]:focus, input[type="submit"]:focus, a.button:focus, a.wp-block-button__link:not(.has-background):active, a.wp-block-button__link:not(.has-background):focus, a.wp-block-button__link:not(.has-background):hover';

if ( defined( 'SEKHLO_PREMIUM_VERSION' ) && version_compare( SEKHLO_PREMIUM_VERSION, '2.4.1', '>' ) ) {
	$buttons_selector .= ', .wc-block-components-button';
	$buttons_hover_selector .= ', .wc-block-components-button:hover';
}

sekhlopress_Customize_Field::add_field(
	'sekhlo_settings[form_button_background_color]',
	'sekhlopress_Customize_Color_Control',
	array(
		'default' => $color_defaults['form_button_background_color'],
		'sanitize_callback' => 'sekhlo_sanitize_rgba_color',
		'transport' => 'postMessage',
	),
	array(
		'label' => __( 'Background', 'sekhlopress' ),
		'section' => 'sekhlo_colors_section',
		'choices' => array(
			'alpha' => true,
			'toggleId' => 'button-colors',
			'wrapper' => 'form_button_background_color',
			'tooltip' => __( 'Choose Initial Color', 'sekhlopress' ),
		),
		'output' => array(
			array(
				'element'  => $buttons_selector,
				'property' => 'background-color',
			),
		),
	)
);

sekhlopress_Customize_Field::add_field(
	'sekhlo_settings[form_button_background_color_hover]',
	'sekhlopress_Customize_Color_Control',
	array(
		'default' => $color_defaults['form_button_background_color_hover'],
		'sanitize_callback' => 'sekhlo_sanitize_rgba_color',
		'transport' => 'postMessage',
	),
	array(
		'label' => __( 'Background Hover', 'sekhlopress' ),
		'section' => 'sekhlo_colors_section',
		'choices' => array(
			'alpha' => true,
			'toggleId' => 'button-colors',
			'wrapper' => 'form_button_background_color_hover',
			'tooltip' => __( 'Choose Hover Color', 'sekhlopress' ),
			'hideLabel' => true,
		),
		'output' => array(
			array(
				'element'  => $buttons_hover_selector,
				'property' => 'background-color',
			),
		),
	)
);

sekhlopress_Customize_Field::add_wrapper(
	'sekhlo_buttons_text_wrapper',
	array(
		'section' => 'sekhlo_colors_section',
		'choices' => array(
			'type' => 'color',
			'toggleId' => 'button-colors',
			'items' => array(
				'form_button_text_color',
				'form_button_text_color_hover',
			),
		),
	)
);

sekhlopress_Customize_Field::add_field(
	'sekhlo_settings[form_button_text_color]',
	'sekhlopress_Customize_Color_Control',
	array(
		'default' => $color_defaults['form_button_text_color'],
		'sanitize_callback' => 'sekhlo_sanitize_hex_color',
		'transport' => 'postMessage',
	),
	array(
		'label' => __( 'Text', 'sekhlopress' ),
		'section' => 'sekhlo_colors_section',
		'choices' => array(
			'toggleId' => 'button-colors',
			'wrapper' => 'form_button_text_color',
			'tooltip' => __( 'Choose Initial Color', 'sekhlopress' ),
		),
		'output' => array(
			array(
				'element'  => $buttons_selector,
				'property' => 'color',
			),
		),
	)
);

sekhlopress_Customize_Field::add_field(
	'sekhlo_settings[form_button_text_color_hover]',
	'sekhlopress_Customize_Color_Control',
	array(
		'default' => $color_defaults['form_button_text_color_hover'],
		'sanitize_callback' => 'sekhlo_sanitize_hex_color',
		'transport' => 'postMessage',
	),
	array(
		'label' => __( 'Text Hover', 'sekhlopress' ),
		'section' => 'sekhlo_colors_section',
		'choices' => array(
			'toggleId' => 'button-colors',
			'wrapper' => 'form_button_text_color_hover',
			'tooltip' => __( 'Choose Hover Color', 'sekhlopress' ),
			'hideLabel' => true,
		),
		'output' => array(
			array(
				'element'  => $buttons_hover_selector,
				'property' => 'color',
			),
		),
	)
);
