<?php
/**
 * The template for displaying the header.
 *
 * @package sekhlopress
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?> <?php sekhlo_do_microdata( 'body' ); ?>>
	<?php
	/**
	 * wp_body_open hook.
	 *
	 * @since 2.3
	 */
	do_action( 'wp_body_open' ); // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedHooknameFound -- core WP hook.

	/**
	 * sekhlo_before_header hook.
	 *
	 * @since 0.1
	 *
	 * @hooked sekhlo_do_skip_to_content_link - 2
	 * @hooked sekhlo_top_bar - 5
	 * @hooked sekhlo_add_navigation_before_header - 5
	 */
	do_action( 'sekhlo_before_header' );

	/**
	 * sekhlo_header hook.
	 *
	 * @since 1.3.42
	 *
	 * @hooked sekhlo_construct_header - 10
	 */
	do_action( 'sekhlo_header' );

	/**
	 * sekhlo_after_header hook.
	 *
	 * @since 0.1
	 *
	 * @hooked sekhlo_featured_page_header - 10
	 */
	do_action( 'sekhlo_after_header' );
	?>

	<div <?php sekhlo_do_attr( 'page' ); ?>>
		<?php
		/**
		 * sekhlo_inside_site_container hook.
		 *
		 * @since 2.4
		 */
		do_action( 'sekhlo_inside_site_container' );
		?>
		<div <?php sekhlo_do_attr( 'site-content' ); ?>>
			<?php
			/**
			 * sekhlo_inside_container hook.
			 *
			 * @since 0.1
			 */
			do_action( 'sekhlo_inside_container' );
