<?php
/**
 * The template used for displaying page content in page.php
 *
 * @package sekhlopress
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?> <?php sekhlo_do_microdata( 'article' ); ?>>
	<div class="inside-article">
		<?php
		/**
		 * sekhlo_before_content hook.
		 *
		 * @since 0.1
		 *
		 * @hooked sekhlo_featured_page_header_inside_single - 10
		 */
		do_action( 'sekhlo_before_content' );

		if ( sekhlo_show_entry_header() ) :
			?>

			<header <?php sekhlo_do_attr( 'entry-header' ); ?>>
				<?php
				/**
				 * sekhlo_before_page_title hook.
				 *
				 * @since 2.4
				 */
				do_action( 'sekhlo_before_page_title' );

				if ( sekhlo_show_title() ) {
					$params = sekhlo_get_the_title_parameters();

					the_title( $params['before'], $params['after'] );
				}

				/**
				 * sekhlo_after_page_title hook.
				 *
				 * @since 2.4
				 */
				do_action( 'sekhlo_after_page_title' );
				?>
			</header>

			<?php
		endif;

		/**
		 * sekhlo_after_entry_header hook.
		 *
		 * @since 0.1
		 *
		 * @hooked sekhlo_post_image - 10
		 */
		do_action( 'sekhlo_after_entry_header' );

		$itemprop = '';

		if ( 'microdata' === sekhlo_get_schema_type() ) {
			$itemprop = ' itemprop="text"';
		}
		?>

		<div class="entry-content"<?php echo $itemprop; // phpcs:ignore -- No escaping needed. ?>>
			<?php
			the_content();

			wp_link_pages(
				array(
					'before' => '<div class="page-links">' . __( 'Pages:', 'sekhlopress' ),
					'after'  => '</div>',
				)
			);
			?>
		</div>

		<?php
		/**
		 * sekhlo_after_content hook.
		 *
		 * @since 0.1
		 */
		do_action( 'sekhlo_after_content' );
		?>
	</div>
</article>
