<?php
/**
 * The template for displaying Archive pages.
 *
 * @package sekhlopress
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

get_header(); ?>

	<div <?php sekhlo_do_attr( 'content' ); ?>>
		<main <?php sekhlo_do_attr( 'main' ); ?>>
			<?php
			/**
			 * sekhlo_before_main_content hook.
			 *
			 * @since 0.1
			 */
			do_action( 'sekhlo_before_main_content' );

			if ( sekhlo_has_default_loop() ) {
				if ( have_posts() ) :

					/**
					 * sekhlo_archive_title hook.
					 *
					 * @since 0.1
					 *
					 * @hooked sekhlo_archive_title - 10
					 */
					do_action( 'sekhlo_archive_title' );

					/**
					 * sekhlo_before_loop hook.
					 *
					 * @since 3.1.0
					 */
					do_action( 'sekhlo_before_loop', 'archive' );

					while ( have_posts() ) :

						the_post();

						sekhlo_do_template_part( 'archive' );

					endwhile;

					/**
					 * sekhlo_after_loop hook.
					 *
					 * @since 2.3
					 */
					do_action( 'sekhlo_after_loop', 'archive' );

				else :

					sekhlo_do_template_part( 'none' );

				endif;
			}

			/**
			 * sekhlo_after_main_content hook.
			 *
			 * @since 0.1
			 */
			do_action( 'sekhlo_after_main_content' );
			?>
		</main>
	</div>

	<?php
	/**
	 * sekhlo_after_primary_content_area hook.
	 *
	 * @since 2.0
	 */
	do_action( 'sekhlo_after_primary_content_area' );

	sekhlo_construct_sidebars();

	get_footer();
