<?php
// No direct access, please
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_action( 'customize_controls_enqueue_scripts', 'SekhloPress_woocommerce_customizer_scripts' );
/**
 * Add our Customizer scripts.
 */
function SekhloPress_woocommerce_customizer_scripts() {
	wp_enqueue_script( 'sekhlo-wc-customizer', trailingslashit( plugin_dir_url( __FILE__ ) ) . 'js/customizer.js', array( 'jquery','customize-controls' ), SEKHLO_WOOCOMMERCE_VERSION, true );
}

add_action( 'customize_preview_init', 'SekhloPress_wc_live_preview_scripts', 20 );
/**
 * Add our live preview scripts.
 */
function SekhloPress_wc_live_preview_scripts() {
	wp_enqueue_script( 'sekhlo-wc-colors-customizer' );
}

/**
 * Active callback to check if the cart menu item is active.
 *
 * @since 1.7
 */
function SekhloPress_wc_menu_cart_active() {
	return SekhloPress_wc_get_setting( 'cart_menu_item' );
}

add_action( 'customize_register', 'SekhloPress_woocommerce_customize_register' );
/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function SekhloPress_woocommerce_customize_register( $wp_customize ) {

	// Defaults
	$defaults = SekhloPress_wc_defaults();

	// Controls
	require_once SEKHLO_LIBRARY_DIRECTORY . 'customizer-helpers.php';

	// Add control types so controls can be built using JS
	if ( method_exists( $wp_customize, 'register_control_type' ) ) {
		$wp_customize->register_control_type( 'SekhloPress_Title_Customize_Control' );
		$wp_customize->register_control_type( 'SekhloPress_Pro_Range_Slider_Control' );
		$wp_customize->register_control_type( 'SekhloPress_Information_Customize_Control' );
		$wp_customize->register_control_type( 'SekhloPress_Section_Shortcut_Control' );
	}

	$wp_customize->add_section(
		'sekhlo_woocommerce_layout',
		array(
			'title' => __( 'WooCommerce', 'sekhlopress-connect' ),
			'capability' => 'edit_theme_options',
			'priority' => 100,
			'panel' => 'sekhlo_layout_panel'
		)
	);

	$wp_customize->add_control(
		new SekhloPress_Section_Shortcut_Control(
			$wp_customize,
			'sekhlo_woocommerce_layout_shortcuts',
			array(
				'section' => 'sekhlo_woocommerce_layout',
				'element' => __( 'WooCommerce', 'sekhlopress-connect' ),
				'shortcuts' => array(
					'colors' => 'sekhlo_woocommerce_colors',
					'typography' => 'sekhlo_woocommerce_typography',
				),
				'settings' => ( isset( $wp_customize->selective_refresh ) ) ? array() : 'blogname',
				'priority' => 0,
			)
		)
	);

	$wp_customize->add_control(
		new SekhloPress_Title_Customize_Control(
			$wp_customize,
			'sekhlo_woocommerce_general_title',
			array(
				'section'     => 'sekhlo_woocommerce_layout',
				'type'        => 'sekhlopress-customizer-title',
				'title'			=> __( 'General', 'sekhlopress-connect' ),
				'settings' => ( isset( $wp_customize->selective_refresh ) ) ? array() : 'blogname'
			)
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[cart_menu_item]',
		array(
			'default' => $defaults['cart_menu_item'],
			'type' => 'option',
			'sanitize_callback' => 'sekhlo_premium_sanitize_checkbox'
		)
	);

	$wp_customize->add_control(
		'sekhlo_woocommerce_settings[cart_menu_item]',
		array(
			'type' => 'checkbox',
			'label' => __( 'Display cart in menu', 'sekhlopress-connect' ),
			'section' => 'sekhlo_woocommerce_layout',
			'settings' => 'sekhlo_woocommerce_settings[cart_menu_item]',
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[menu_mini_cart]',
		array(
			'default' => $defaults['menu_mini_cart'],
			'type' => 'option',
			'sanitize_callback' => 'sekhlo_premium_sanitize_checkbox'
		)
	);

	$wp_customize->add_control(
		'sekhlo_woocommerce_settings[menu_mini_cart]',
		array(
			'type' => 'checkbox',
			'label' => __( 'Display mini cart sub-menu', 'sekhlopress-connect' ),
			'section' => 'sekhlo_woocommerce_layout',
			'settings' => 'sekhlo_woocommerce_settings[menu_mini_cart]',
			'active_callback' => 'sekhlo_premium_wc_menu_item_active',
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[cart_menu_item_icon]',
		array(
			'default' => $defaults['cart_menu_item_icon'],
			'type' => 'option',
			'sanitize_callback' => 'sekhlo_premium_sanitize_choices'
		)
	);

	$wp_customize->add_control(
		'sekhlo_woocommerce_settings[cart_menu_item_icon]',
		array(
			'type' => 'select',
			'label' => __( 'Menu Item Icon', 'sekhlopress-connect' ),
			'section' => 'sekhlo_woocommerce_layout',
			'choices' => array(
				'shopping-cart' => __( 'Shopping Cart', 'sekhlopress-connect' ),
				'shopping-bag' => __( 'Shopping Bag', 'sekhlopress-connect' ),
				'shopping-basket' => __( 'Shopping Basket', 'sekhlopress-connect' ),
			),
			'settings' => 'sekhlo_woocommerce_settings[cart_menu_item_icon]',
			'active_callback' => 'SekhloPress_wc_menu_cart_active',
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[cart_menu_item_content]',
		array(
			'default' => $defaults['cart_menu_item_content'],
			'type' => 'option',
			'sanitize_callback' => 'sekhlo_premium_sanitize_choices'
		)
	);

	$wp_customize->add_control(
		'sekhlo_woocommerce_settings[cart_menu_item_content]',
		array(
			'type' => 'select',
			'label' => __( 'Menu Item Content', 'sekhlopress-connect' ),
			'section' => 'sekhlo_woocommerce_layout',
			'choices' => array(
				'amount' => __( 'Amount', 'sekhlopress-connect' ),
				'number' => __( 'Number of Items', 'sekhlopress-connect' ),
			),
			'settings' => 'sekhlo_woocommerce_settings[cart_menu_item_content]',
			'active_callback' => 'SekhloPress_wc_menu_cart_active',
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[breadcrumbs]',
		array(
			'default' => $defaults['breadcrumbs'],
			'type' => 'option',
			'sanitize_callback' => 'sekhlo_premium_sanitize_checkbox'
		)
	);

	$wp_customize->add_control(
		'sekhlo_woocommerce_settings[breadcrumbs]',
		array(
			'type' => 'checkbox',
			'label' => __( 'Display breadcrumbs', 'sekhlopress-connect' ),
			'section' => 'sekhlo_woocommerce_layout',
			'settings' => 'sekhlo_woocommerce_settings[breadcrumbs]',
		)
	);

	$wp_customize->add_control(
		new SekhloPress_Title_Customize_Control(
			$wp_customize,
			'sekhlo_woocommerce_shop_page_title',
			array(
				'section'     => 'sekhlo_woocommerce_layout',
				'type'        => 'sekhlopress-customizer-title',
				'title'			=> __( 'Shop', 'sekhlopress-connect' ),
				'settings' => ( isset( $wp_customize->selective_refresh ) ) ? array() : 'blogname'
			)
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[sidebar_layout]',
		array(
			'default' => $defaults['sidebar_layout'],
			'type' => 'option',
			'sanitize_callback' => 'sekhlo_premium_sanitize_choices'
		)
	);

	$wp_customize->add_control(
		'sekhlo_woocommerce_settings[sidebar_layout]',
		array(
			'type' => 'select',
			'label' => __( 'Sidebar Layout', 'sekhlopress-connect' ),
			'section' => 'sekhlo_woocommerce_layout',
			'choices' => array(
				'left-sidebar' => __( 'Sidebar / Content', 'sekhlopress-connect' ),
				'right-sidebar' => __( 'Content / Sidebar', 'sekhlopress-connect' ),
				'no-sidebar' => __( 'Content (no sidebars)', 'sekhlopress-connect' ),
				'both-sidebars' => __( 'Sidebar / Content / Sidebar', 'sekhlopress-connect' ),
				'both-left' => __( 'Sidebar / Sidebar / Content', 'sekhlopress-connect' ),
				'both-right' => __( 'Content / Sidebar / Sidebar', 'sekhlopress-connect' )
			),
			'settings' => 'sekhlo_woocommerce_settings[sidebar_layout]',
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[columns]', array(
			'default' => $defaults['columns'],
			'type' => 'option',
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'absint'
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[tablet_columns]', array(
			'default' => $defaults['tablet_columns'],
			'type' => 'option',
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'absint'
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[mobile_columns]', array(
			'default' => $defaults['mobile_columns'],
			'type' => 'option',
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'absint'
		)
	);

	$wp_customize->add_control(
		new SekhloPress_Pro_Range_Slider_Control(
			$wp_customize,
			'gp_woocommerce_columns',
			array(
				'label' => __( 'Product Columns', 'sekhlopress-connect' ),
				'section' => 'sekhlo_woocommerce_layout',
				'settings' => array(
					'desktop' => 'sekhlo_woocommerce_settings[columns]',
					'tablet' => 'sekhlo_woocommerce_settings[tablet_columns]',
					'mobile' => 'sekhlo_woocommerce_settings[mobile_columns]',
				),
				'choices' => array(
					'desktop' => array(
						'min' => 1,
						'max' => 6,
						'step' => 1,
						'edit' => false,
						'unit' => 'Col',
					),
					'tablet' => array(
						'min' => 1,
						'max' => 3,
						'step' => 1,
						'edit' => false,
						'unit' => 'Col',
					),
					'mobile' => array(
						'min' => 1,
						'max' => 3,
						'step' => 1,
						'edit' => false,
						'unit' => 'Col',
					),
				),
			)
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[columns_gap]', array(
			'default' => $defaults['columns_gap'],
			'type' => 'option',
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'absint'
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[tablet_columns_gap]', array(
			'default' => $defaults['tablet_columns_gap'],
			'type' => 'option',
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'sekhlo_premium_sanitize_empty_absint'
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[mobile_columns_gap]', array(
			'default' => $defaults['mobile_columns_gap'],
			'type' => 'option',
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'sekhlo_premium_sanitize_empty_absint'
		)
	);

	$wp_customize->add_control(
		new SekhloPress_Pro_Range_Slider_Control(
			$wp_customize,
			'gp_woocommerce_column_gap',
			array(
				'label' => __( 'Column Gap', 'sekhlopress-connect' ),
				'section' => 'sekhlo_woocommerce_layout',
				'settings' => array(
					'desktop' => 'sekhlo_woocommerce_settings[columns_gap]',
					'tablet' => 'sekhlo_woocommerce_settings[tablet_columns_gap]',
					'mobile' => 'sekhlo_woocommerce_settings[mobile_columns_gap]',
				),
				'choices' => array(
					'desktop' => array(
						'min' => 0,
						'max' => 100,
						'step' => 5,
						'edit' => true,
						'unit' => 'px',
					),
					'tablet' => array(
						'min' => 0,
						'max' => 100,
						'step' => 5,
						'edit' => true,
						'unit' => 'px',
					),
					'mobile' => array(
						'min' => 0,
						'max' => 100,
						'step' => 5,
						'edit' => true,
						'unit' => 'px',
					),
				),
			)
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[product_archive_image_alignment]',
		array(
			'default' => $defaults['product_archive_image_alignment'],
			'type' => 'option',
			'sanitize_callback' => 'sekhlo_premium_sanitize_choices'
		)
	);

	$wp_customize->add_control(
		'sekhlo_woocommerce_settings[product_archive_image_alignment]',
		array(
			'type' => 'radio',
			'label' => __( 'Image Alignment', 'sekhlopress-connect' ),
			'section' => 'sekhlo_woocommerce_layout',
			'choices' => array(
				'left' => __( 'Left', 'sekhlopress-connect' ),
				'center' => __( 'Center', 'sekhlopress-connect' ),
				'right' => __( 'Right', 'sekhlopress-connect' ),
			),
			'settings' => 'sekhlo_woocommerce_settings[product_archive_image_alignment]',
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[products_per_page]',
		array(
			'default' => $defaults['products_per_page'],
			'type' => 'option',
			'sanitize_callback' => 'absint'
		)
	);

	$wp_customize->add_control(
		'sekhlo_woocommerce_settings[products_per_page]',
		array(
			'type' => 'text',
			'label' => __( 'Products Per Page', 'sekhlopress-connect' ),
			'section' => 'sekhlo_woocommerce_layout',
			'settings' => 'sekhlo_woocommerce_settings[products_per_page]',
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[product_archive_alignment]',
		array(
			'default' => $defaults['product_archive_alignment'],
			'type' => 'option',
			'sanitize_callback' => 'sekhlo_premium_sanitize_choices'
		)
	);

	$wp_customize->add_control(
		'sekhlo_woocommerce_settings[product_archive_alignment]',
		array(
			'type' => 'radio',
			'label' => __( 'Text Alignment', 'sekhlopress-connect' ),
			'section' => 'sekhlo_woocommerce_layout',
			'choices' => array(
				'left' => __( 'Left', 'sekhlopress-connect' ),
				'center' => __( 'Center', 'sekhlopress-connect' ),
				'right' => __( 'Right', 'sekhlopress-connect' ),
			),
			'settings' => 'sekhlo_woocommerce_settings[product_archive_alignment]',
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[off_canvas_panel_on_add_to_cart]',
		array(
			'default' => $defaults['off_canvas_panel_on_add_to_cart'],
			'type' => 'option',
			'sanitize_callback' => 'sekhlo_premium_sanitize_checkbox'
		)
	);

	$wp_customize->add_control(
		'sekhlo_woocommerce_settings[off_canvas_panel_on_add_to_cart]',
		array(
			'type' => 'checkbox',
			'label' => __( 'Display cart panel on add to cart', 'sekhlopress-connect' ),
			'section' => 'sekhlo_woocommerce_layout',
			'settings' => 'sekhlo_woocommerce_settings[off_canvas_panel_on_add_to_cart]',
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[shop_page_title]',
		array(
			'default' => $defaults['shop_page_title'],
			'type' => 'option',
			'sanitize_callback' => 'sekhlo_premium_sanitize_checkbox'
		)
	);

	$wp_customize->add_control(
		'sekhlo_woocommerce_settings[shop_page_title]',
		array(
			'type' => 'checkbox',
			'label' => __( 'Display page title', 'sekhlopress-connect' ),
			'section' => 'sekhlo_woocommerce_layout',
			'settings' => 'sekhlo_woocommerce_settings[shop_page_title]',
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[product_results_count]',
		array(
			'default' => $defaults['product_results_count'],
			'type' => 'option',
			'sanitize_callback' => 'sekhlo_premium_sanitize_checkbox'
		)
	);

	$wp_customize->add_control(
		'sekhlo_woocommerce_settings[product_results_count]',
		array(
			'type' => 'checkbox',
			'label' => __( 'Display product results count', 'sekhlopress-connect' ),
			'section' => 'sekhlo_woocommerce_layout',
			'settings' => 'sekhlo_woocommerce_settings[product_results_count]',
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[product_sorting]',
		array(
			'default' => $defaults['product_sorting'],
			'type' => 'option',
			'sanitize_callback' => 'sekhlo_premium_sanitize_checkbox'
		)
	);

	$wp_customize->add_control(
		'sekhlo_woocommerce_settings[product_sorting]',
		array(
			'type' => 'checkbox',
			'label' => __( 'Display product sorting', 'sekhlopress-connect' ),
			'section' => 'sekhlo_woocommerce_layout',
			'settings' => 'sekhlo_woocommerce_settings[product_sorting]',
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[product_archive_image]',
		array(
			'default' => $defaults['product_archive_image'],
			'type' => 'option',
			'sanitize_callback' => 'sekhlo_premium_sanitize_checkbox'
		)
	);

	$wp_customize->add_control(
		'sekhlo_woocommerce_settings[product_archive_image]',
		array(
			'type' => 'checkbox',
			'label' => __( 'Display product image', 'sekhlopress-connect' ),
			'section' => 'sekhlo_woocommerce_layout',
			'settings' => 'sekhlo_woocommerce_settings[product_archive_image]',
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[product_secondary_image]',
		array(
			'default' => $defaults['product_secondary_image'],
			'type' => 'option',
			'sanitize_callback' => 'sekhlo_premium_sanitize_checkbox'
		)
	);

	$wp_customize->add_control(
		'sekhlo_woocommerce_settings[product_secondary_image]',
		array(
			'type' => 'checkbox',
			'label' => __( 'Display secondary image on hover', 'sekhlopress-connect' ),
			'section' => 'sekhlo_woocommerce_layout',
			'settings' => 'sekhlo_woocommerce_settings[product_secondary_image]',
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[product_archive_title]',
		array(
			'default' => $defaults['product_archive_title'],
			'type' => 'option',
			'sanitize_callback' => 'sekhlo_premium_sanitize_checkbox'
		)
	);

	$wp_customize->add_control(
		'sekhlo_woocommerce_settings[product_archive_title]',
		array(
			'type' => 'checkbox',
			'label' => __( 'Display product title', 'sekhlopress-connect' ),
			'section' => 'sekhlo_woocommerce_layout',
			'settings' => 'sekhlo_woocommerce_settings[product_archive_title]',
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[product_archive_sale_flash]',
		array(
			'default' => $defaults['product_archive_sale_flash'],
			'type' => 'option',
			'sanitize_callback' => 'sekhlo_premium_sanitize_checkbox'
		)
	);

	$wp_customize->add_control(
		'sekhlo_woocommerce_settings[product_archive_sale_flash]',
		array(
			'type' => 'checkbox',
			'label' => __( 'Display sale flash', 'sekhlopress-connect' ),
			'section' => 'sekhlo_woocommerce_layout',
			'settings' => 'sekhlo_woocommerce_settings[product_archive_sale_flash]',
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[product_archive_sale_flash_overlay]',
		array(
			'default' => $defaults['product_archive_sale_flash_overlay'],
			'type' => 'option',
			'sanitize_callback' => 'sekhlo_premium_sanitize_checkbox'
		)
	);

	$wp_customize->add_control(
		'sekhlo_woocommerce_settings[product_archive_sale_flash_overlay]',
		array(
			'type' => 'checkbox',
			'label' => __( 'Sale flash over image', 'sekhlopress-connect' ),
			'section' => 'sekhlo_woocommerce_layout',
			'settings' => 'sekhlo_woocommerce_settings[product_archive_sale_flash_overlay]',
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[product_archive_rating]',
		array(
			'default' => $defaults['product_archive_rating'],
			'type' => 'option',
			'sanitize_callback' => 'sekhlo_premium_sanitize_checkbox'
		)
	);

	$wp_customize->add_control(
		'sekhlo_woocommerce_settings[product_archive_rating]',
		array(
			'type' => 'checkbox',
			'label' => __( 'Display rating', 'sekhlopress-connect' ),
			'section' => 'sekhlo_woocommerce_layout',
			'settings' => 'sekhlo_woocommerce_settings[product_archive_rating]',
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[product_archive_price]',
		array(
			'default' => $defaults['product_archive_price'],
			'type' => 'option',
			'sanitize_callback' => 'sekhlo_premium_sanitize_checkbox'
		)
	);

	$wp_customize->add_control(
		'sekhlo_woocommerce_settings[product_archive_price]',
		array(
			'type' => 'checkbox',
			'label' => __( 'Display price', 'sekhlopress-connect' ),
			'section' => 'sekhlo_woocommerce_layout',
			'settings' => 'sekhlo_woocommerce_settings[product_archive_price]',
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[product_archive_add_to_cart]',
		array(
			'default' => $defaults['product_archive_add_to_cart'],
			'type' => 'option',
			'sanitize_callback' => 'sekhlo_premium_sanitize_checkbox'
		)
	);

	$wp_customize->add_control(
		'sekhlo_woocommerce_settings[product_archive_add_to_cart]',
		array(
			'type' => 'checkbox',
			'label' => __( 'Display add to cart button', 'sekhlopress-connect' ),
			'section' => 'sekhlo_woocommerce_layout',
			'settings' => 'sekhlo_woocommerce_settings[product_archive_add_to_cart]',
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[product_archive_description]',
		array(
			'default' => $defaults['product_archive_description'],
			'type' => 'option',
			'sanitize_callback' => 'sekhlo_premium_sanitize_checkbox'
		)
	);

	$wp_customize->add_control(
		'sekhlo_woocommerce_settings[product_archive_description]',
		array(
			'type' => 'checkbox',
			'label' => __( 'Display short description', 'sekhlopress-connect' ),
			'section' => 'sekhlo_woocommerce_layout',
			'settings' => 'sekhlo_woocommerce_settings[product_archive_description]',
		)
	);

	$wp_customize->add_control(
		new SekhloPress_Title_Customize_Control(
			$wp_customize,
			'sekhlo_woocommerce_single_product_title',
			array(
				'section'     => 'sekhlo_woocommerce_layout',
				'type'        => 'sekhlopress-customizer-title',
				'title'			=> __( 'Single Product', 'sekhlopress-connect' ),
				'settings' => ( isset( $wp_customize->selective_refresh ) ) ? array() : 'blogname'
			)
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[single_sidebar_layout]',
		array(
			'default' => $defaults['single_sidebar_layout'],
			'type' => 'option',
			'sanitize_callback' => 'sekhlo_premium_sanitize_choices'
		)
	);

	$wp_customize->add_control(
		'sekhlo_woocommerce_settings[single_sidebar_layout]',
		array(
			'type' => 'select',
			'label' => __( 'Sidebar Layout', 'sekhlopress-connect' ),
			'section' => 'sekhlo_woocommerce_layout',
			'choices' => array(
				'inherit' => __( 'Inherit', 'sekhlopress-connect' ),
				'left-sidebar' => __( 'Sidebar / Content', 'sekhlopress-connect' ),
				'right-sidebar' => __( 'Content / Sidebar', 'sekhlopress-connect' ),
				'no-sidebar' => __( 'Content (no sidebars)', 'sekhlopress-connect' ),
				'both-sidebars' => __( 'Sidebar / Content / Sidebar', 'sekhlopress-connect' ),
				'both-left' => __( 'Sidebar / Sidebar / Content', 'sekhlopress-connect' ),
				'both-right' => __( 'Content / Sidebar / Sidebar', 'sekhlopress-connect' )
			),
			'settings' => 'sekhlo_woocommerce_settings[single_sidebar_layout]',
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[single_product_image_width]', array(
			'default' => $defaults['single_product_image_width'],
			'type' => 'option',
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'absint'
		)
	);

	$wp_customize->add_control(
		new SekhloPress_Pro_Range_Slider_Control(
			$wp_customize,
			'gp_woocommerce_single_product_image_width',
			array(
				'label' => __( 'Product Image Area Width', 'sekhlopress-connect' ),
				'section' => 'sekhlo_woocommerce_layout',
				'settings' => array(
					'desktop' => 'sekhlo_woocommerce_settings[single_product_image_width]',
				),
				'choices' => array(
					'desktop' => array(
						'min' => 10,
						'max' => 100,
						'step' => 5,
						'edit' => true,
						'unit' => '%',
					),
				),
			)
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[sticky_add_to_cart_panel]',
		array(
			'default' => $defaults['sticky_add_to_cart_panel'],
			'type' => 'option',
			'sanitize_callback' => 'sekhlo_premium_sanitize_checkbox'
		)
	);

	$wp_customize->add_control(
		'sekhlo_woocommerce_settings[sticky_add_to_cart_panel]',
		array(
			'type' => 'checkbox',
			'label' => __( 'Display add to cart panel on scroll', 'sekhlopress-connect' ),
			'section' => 'sekhlo_woocommerce_layout',
			'settings' => 'sekhlo_woocommerce_settings[sticky_add_to_cart_panel]',
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[quantity_buttons]',
		array(
			'default' => $defaults['quantity_buttons'],
			'type' => 'option',
			'sanitize_callback' => 'sekhlo_premium_sanitize_checkbox'
		)
	);

	$wp_customize->add_control(
		'sekhlo_woocommerce_settings[quantity_buttons]',
		array(
			'type' => 'checkbox',
			'label' => __( 'Display quantity buttons', 'sekhlopress-connect' ),
			'section' => 'sekhlo_woocommerce_layout',
			'settings' => 'sekhlo_woocommerce_settings[quantity_buttons]',
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[single_product_sale_flash]',
		array(
			'default' => $defaults['single_product_sale_flash'],
			'type' => 'option',
			'sanitize_callback' => 'sekhlo_premium_sanitize_checkbox'
		)
	);

	$wp_customize->add_control(
		'sekhlo_woocommerce_settings[single_product_sale_flash]',
		array(
			'type' => 'checkbox',
			'label' => __( 'Display sale flash', 'sekhlopress-connect' ),
			'section' => 'sekhlo_woocommerce_layout',
			'settings' => 'sekhlo_woocommerce_settings[single_product_sale_flash]',
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[product_tabs]',
		array(
			'default' => $defaults['product_tabs'],
			'type' => 'option',
			'sanitize_callback' => 'sekhlo_premium_sanitize_checkbox'
		)
	);

	$wp_customize->add_control(
		'sekhlo_woocommerce_settings[product_tabs]',
		array(
			'type' => 'checkbox',
			'label' => __( 'Display product tabs', 'sekhlopress-connect' ),
			'section' => 'sekhlo_woocommerce_layout',
			'settings' => 'sekhlo_woocommerce_settings[product_tabs]',
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[product_related]',
		array(
			'default' => $defaults['product_related'],
			'type' => 'option',
			'sanitize_callback' => 'sekhlo_premium_sanitize_checkbox'
		)
	);

	$wp_customize->add_control(
		'sekhlo_woocommerce_settings[product_related]',
		array(
			'type' => 'checkbox',
			'label' => __( 'Display related products', 'sekhlopress-connect' ),
			'section' => 'sekhlo_woocommerce_layout',
			'settings' => 'sekhlo_woocommerce_settings[product_related]',
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[product_upsells]',
		array(
			'default' => $defaults['product_upsells'],
			'type' => 'option',
			'sanitize_callback' => 'sekhlo_premium_sanitize_checkbox'
		)
	);

	$wp_customize->add_control(
		'sekhlo_woocommerce_settings[product_upsells]',
		array(
			'type' => 'checkbox',
			'label' => __( 'Display upsell products', 'sekhlopress-connect' ),
			'section' => 'sekhlo_woocommerce_layout',
			'settings' => 'sekhlo_woocommerce_settings[product_upsells]',
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[related_upsell_columns]', array(
			'default' => $defaults['related_upsell_columns'],
			'type' => 'option',
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'absint'
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[tablet_related_upsell_columns]', array(
			'default' => $defaults['tablet_related_upsell_columns'],
			'type' => 'option',
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'absint'
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[mobile_related_upsell_columns]', array(
			'default' => $defaults['mobile_related_upsell_columns'],
			'type' => 'option',
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'absint'
		)
	);

	$wp_customize->add_control(
		new SekhloPress_Pro_Range_Slider_Control(
			$wp_customize,
			'gp_woocommerce_related_upsell_columns',
			array(
				'label' => __( 'Related/Upsell Columns', 'sekhlopress-connect' ),
				'section' => 'sekhlo_woocommerce_layout',
				'settings' => array(
					'desktop' => 'sekhlo_woocommerce_settings[related_upsell_columns]',
					'tablet' => 'sekhlo_woocommerce_settings[tablet_related_upsell_columns]',
					'mobile' => 'sekhlo_woocommerce_settings[mobile_related_upsell_columns]',
				),
				'choices' => array(
					'desktop' => array(
						'min' => 1,
						'max' => 6,
						'step' => 1,
						'edit' => false,
						'unit' => 'Col',
					),
					'tablet' => array(
						'min' => 1,
						'max' => 3,
						'step' => 1,
						'edit' => false,
						'unit' => 'Col',
					),
					'mobile' => array(
						'min' => 1,
						'max' => 3,
						'step' => 1,
						'edit' => false,
						'unit' => 'Col',
					),
				),
			)
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[product_meta]',
		array(
			'default' => $defaults['product_meta'],
			'type' => 'option',
			'sanitize_callback' => 'sekhlo_premium_sanitize_checkbox'
		)
	);

	$wp_customize->add_control(
		'sekhlo_woocommerce_settings[product_meta]',
		array(
			'type' => 'checkbox',
			'label' => __( 'Display product meta data', 'sekhlopress-connect' ),
			'section' => 'sekhlo_woocommerce_layout',
			'settings' => 'sekhlo_woocommerce_settings[product_meta]',
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[product_description]',
		array(
			'default' => $defaults['product_description'],
			'type' => 'option',
			'sanitize_callback' => 'sekhlo_premium_sanitize_checkbox'
		)
	);

	$wp_customize->add_control(
		'sekhlo_woocommerce_settings[product_description]',
		array(
			'type' => 'checkbox',
			'label' => __( 'Display short description', 'sekhlopress-connect' ),
			'section' => 'sekhlo_woocommerce_layout',
			'settings' => 'sekhlo_woocommerce_settings[product_description]',
		)
	);

	$wp_customize->add_section(
		'sekhlo_woocommerce_colors',
		array(
			'title' => __( 'WooCommerce', 'sekhlopress-connect' ),
			'capability' => 'edit_theme_options',
			'priority' => 200,
			'panel' => 'sekhlo_colors_panel'
		)
	);

	$wp_customize->add_section(
		'sekhlo_woocommerce_typography',
		array(
			'title' => __( 'WooCommerce', 'sekhlopress-connect' ),
			'capability' => 'edit_theme_options',
			'priority' => 200,
			'panel' => 'sekhlo_typography_panel'
		)
	);

	$wp_customize->add_control(
		new SekhloPress_Title_Customize_Control(
			$wp_customize,
			'sekhlo_woocommerce_checkout_title',
			array(
				'section'     => 'sekhlo_woocommerce_layout',
				'type'        => 'sekhlopress-customizer-title',
				'title'			=> __( 'Checkout', 'sekhlopress-connect' ),
				'settings' => ( isset( $wp_customize->selective_refresh ) ) ? array() : 'blogname'
			)
		)
	);

	$wp_customize->add_setting(
		'sekhlo_woocommerce_settings[distraction_free]',
		array(
			'default' => $defaults['distraction_free'],
			'type' => 'option',
			'sanitize_callback' => 'sekhlo_premium_sanitize_checkbox'
		)
	);

	$wp_customize->add_control(
		'sekhlo_woocommerce_settings[distraction_free]',
		array(
			'type' => 'checkbox',
			'label' => __( 'Distraction-free mode', 'sekhlopress-connect' ),
			'description' => __( 'Remove unnecessary distractions like sidebars, footer widgets and sticky menus.', 'sekhlopress-connect' ),
			'section' => 'sekhlo_woocommerce_layout',
			'settings' => 'sekhlo_woocommerce_settings[distraction_free]',
		)
	);

}
