<?php
/**
 * This file handles the customizer fields for the slideout navigation colors.
 *
 * @package SekhloPress
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // No direct access, please.
}

if ( ! function_exists( 'sekhlo_register_slideout_nav_colors' ) ) {
	add_action( 'sekhlo_customize_after_primary_navigation', 'sekhlo_register_slideout_nav_colors', 1000 );
	/**
	 * Register the slideout navigation color fields.
	 */
	function sekhlo_register_slideout_nav_colors() {
		if ( ! class_exists( 'SekhloPress_Customize_Field' ) ) {
			return;
		}

		$color_defaults = sekhlo_get_color_defaults();

		$menu_hover_selectors = '.slideout-navigation.main-navigation .main-nav ul li:not([class*="current-menu-"]):hover > a, .slideout-navigation.main-navigation .main-nav ul li:not([class*="current-menu-"]):focus > a, .slideout-navigation.main-navigation .main-nav ul li.sfHover:not([class*="current-menu-"]) > a, .slideout-navigation.main-navigation .menu-bar-item:hover > a, .slideout-navigation.main-navigation .menu-bar-item.sfHover > a';
		$menu_current_selectors = '.slideout-navigation.main-navigation .main-nav ul li[class*="current-menu-"] > a';
		$text_selectors = '.slideout-navigation.main-navigation .main-nav ul li a, .slideout-navigation.main-navigation .menu-toggle, .slideout-navigation.main-navigation button.menu-toggle:hover, .slideout-navigation.main-navigation button.menu-toggle:focus, .slideout-navigation.main-navigation .mobile-bar-items a, .slideout-navigation.main-navigation .mobile-bar-items a:hover, .slideout-navigation.main-navigation .mobile-bar-items a:focus, .slideout-navigation.main-navigation .menu-bar-items';
		$submenu_hover_selectors = '.slideout-navigation.main-navigation .main-nav ul ul li:not([class*="current-menu-"]):hover > a, .slideout-navigation.main-navigation .main-nav ul ul li:not([class*="current-menu-"]):focus > a, .slideout-navigation.main-navigation .main-nav ul ul li.sfHover:not([class*="current-menu-"]) > a';
		$submenu_current_selectors = '.slideout-navigation.main-navigation .main-nav ul ul li[class*="current-menu-"] > a';

		SekhloPress_Customize_Field::add_title(
			'sekhlo_slideout_navigation_colors_title',
			array(
				'section' => 'sekhlo_colors_section',
				'title' => __( 'Off Canvas Panel', 'sekhlopress-connect' ),
				'choices' => array(
					'toggleId' => 'slideout-navigation-colors',
				),
				'active_callback' => function() {
					$settings = wp_parse_args(
						get_option( 'sekhlo_menu_plus_settings', array() ),
						sekhlo_menu_plus_get_defaults()
					);

					if ( 'false' !== $settings['slideout_menu'] ) {
						return true;
					}

					return false;
				},
			)
		);

		// Navigation background group.
		SekhloPress_Customize_Field::add_color_field_group(
			'slideout_navigation_background',
			'sekhlo_colors_section',
			'slideout-navigation-colors',
			array(
				'sekhlo_settings[slideout_background_color]' => array(
					'default_value' => $color_defaults['slideout_background_color'],
					'label' => __( 'Navigation Background', 'sekhlopress-connect' ),
					'tooltip' => __( 'Choose Initial Color', 'sekhlopress-connect' ),
					'element' => '.slideout-navigation.main-navigation',
					'property' => 'background-color',
					'hide_label' => false,
				),
				'sekhlo_settings[slideout_background_hover_color]' => array(
					'default_value' => $color_defaults['slideout_background_hover_color'],
					'label' => __( 'Navigation Background Hover', 'sekhlopress-connect' ),
					'tooltip' => __( 'Choose Hover Color', 'sekhlopress-connect' ),
					'element' => $menu_hover_selectors,
					'property' => 'background-color',
					'hide_label' => true,
				),
				'sekhlo_settings[slideout_background_current_color]' => array(
					'default_value' => $color_defaults['slideout_background_current_color'],
					'label' => __( 'Navigation Background Current', 'sekhlopress-connect' ),
					'tooltip' => __( 'Choose Current Color', 'sekhlopress-connect' ),
					'element' => $menu_current_selectors,
					'property' => 'background-color',
					'hide_label' => true,
				),
			)
		);

		// Navigation text group.
		SekhloPress_Customize_Field::add_color_field_group(
			'slideout_navigation_text',
			'sekhlo_colors_section',
			'slideout-navigation-colors',
			array(
				'sekhlo_settings[slideout_text_color]' => array(
					'default_value' => $color_defaults['slideout_text_color'],
					'label' => __( 'Navigation Text', 'sekhlopress-connect' ),
					'tooltip' => __( 'Choose Initial Color', 'sekhlopress-connect' ),
					'element' => $text_selectors,
					'property' => 'color',
					'hide_label' => false,
				),
				'sekhlo_settings[slideout_text_hover_color]' => array(
					'default_value' => $color_defaults['slideout_text_hover_color'],
					'label' => __( 'Navigation Text Hover', 'sekhlopress-connect' ),
					'tooltip' => __( 'Choose Hover Color', 'sekhlopress-connect' ),
					'element' => $menu_hover_selectors,
					'property' => 'color',
					'hide_label' => true,
				),
				'sekhlo_settings[slideout_text_current_color]' => array(
					'default_value' => $color_defaults['slideout_text_current_color'],
					'label' => __( 'Navigation Text Current', 'sekhlopress-connect' ),
					'tooltip' => __( 'Choose Current Color', 'sekhlopress-connect' ),
					'element' => $menu_current_selectors,
					'property' => 'color',
					'hide_label' => true,
				),
			)
		);

		// Sub-Menu background group.
		SekhloPress_Customize_Field::add_color_field_group(
			'slideout_navigation_submenu_background',
			'sekhlo_colors_section',
			'slideout-navigation-colors',
			array(
				'sekhlo_settings[slideout_submenu_background_color]' => array(
					'default_value' => $color_defaults['slideout_submenu_background_color'],
					'label' => __( 'Sub-Menu Background', 'sekhlopress-connect' ),
					'tooltip' => __( 'Choose Initial Color', 'sekhlopress-connect' ),
					'element' => '.slideout-navigation.main-navigation ul ul',
					'property' => 'background-color',
					'hide_label' => false,
				),
				'sekhlo_settings[slideout_submenu_background_hover_color]' => array(
					'default_value' => $color_defaults['slideout_submenu_background_hover_color'],
					'label' => __( 'Sub-Menu Background Hover', 'sekhlopress-connect' ),
					'tooltip' => __( 'Choose Hover Color', 'sekhlopress-connect' ),
					'element' => $submenu_hover_selectors,
					'property' => 'background-color',
					'hide_label' => true,
				),
				'sekhlo_settings[slideout_submenu_background_current_color]' => array(
					'default_value' => $color_defaults['slideout_submenu_background_current_color'],
					'label' => __( 'Sub-Menu Background Current', 'sekhlopress-connect' ),
					'tooltip' => __( 'Choose Current Color', 'sekhlopress-connect' ),
					'element' => $submenu_current_selectors,
					'property' => 'background-color',
					'hide_label' => true,
				),
			)
		);

		// Sub-Menu text group.
		SekhloPress_Customize_Field::add_color_field_group(
			'slideout_navigation_submenu_text',
			'sekhlo_colors_section',
			'slideout-navigation-colors',
			array(
				'sekhlo_settings[slideout_submenu_text_color]' => array(
					'default_value' => $color_defaults['slideout_submenu_text_color'],
					'label' => __( 'Sub-Menu Text', 'sekhlopress-connect' ),
					'tooltip' => __( 'Choose Initial Color', 'sekhlopress-connect' ),
					'element' => '.slideout-navigation.main-navigation .main-nav ul ul li a',
					'property' => 'color',
					'hide_label' => false,
				),
				'sekhlo_settings[slideout_submenu_text_hover_color]' => array(
					'default_value' => $color_defaults['slideout_submenu_text_hover_color'],
					'label' => __( 'Sub-Menu Text Hover', 'sekhlopress-connect' ),
					'tooltip' => __( 'Choose Hover Color', 'sekhlopress-connect' ),
					'element' => $submenu_hover_selectors,
					'property' => 'color',
					'hide_label' => true,
				),
				'sekhlo_settings[slideout_submenu_text_current_color]' => array(
					'default_value' => $color_defaults['slideout_submenu_text_current_color'],
					'label' => __( 'Sub-Menu Text Current', 'sekhlopress-connect' ),
					'tooltip' => __( 'Choose Current Color', 'sekhlopress-connect' ),
					'element' => $submenu_current_selectors,
					'property' => 'color',
					'hide_label' => true,
				),
			)
		);
	}
}
