jQuery( function( $ ) {
	$( '[data-type="overlay_design"]' ).on( 'click', function( e ) {
		e.preventDefault();

		// eslint-disable-next-line no-alert
		if ( ! confirm( gpButtonActions.warning ) ) {
			return;
		}

		( function( api ) {
			'use strict';

			api.instance( 'sekhlo_settings[slideout_background_color]' ).set( gpButtonActions.styling.backgroundColor );
			api.instance( 'sekhlo_settings[slideout_text_color]' ).set( gpButtonActions.styling.textColor );
			api.instance( 'sekhlo_settings[slideout_background_hover_color]' ).set( gpButtonActions.styling.backgroundHoverColor );
			api.instance( 'sekhlo_settings[slideout_background_current_color]' ).set( gpButtonActions.styling.backgroundCurrentColor );

			api.instance( 'sekhlo_settings[slideout_submenu_background_color]' ).set( gpButtonActions.styling.subMenuBackgroundColor );
			api.instance( 'sekhlo_settings[slideout_submenu_text_color]' ).set( gpButtonActions.styling.subMenuTextColor );
			api.instance( 'sekhlo_settings[slideout_submenu_background_hover_color]' ).set( gpButtonActions.styling.subMenuBackgroundHoverColor );
			api.instance( 'sekhlo_settings[slideout_submenu_background_current_color]' ).set( gpButtonActions.styling.subMenuBackgroundCurrentColor );

			api.instance( 'sekhlo_settings[slideout_font_weight]' ).set( gpButtonActions.styling.fontWeight );
			api.instance( 'sekhlo_settings[slideout_font_size]' ).set( gpButtonActions.styling.fontSize );

			$( '.wp-color-picker' ).wpColorPicker().change();
		}( wp.customize ) );
	} );

	$( '[data-type="resekhlo_external_css"]' ).on( 'click', function( e ) {
		var $thisButton = $( this ); // eslint-disable-line no-var
		e.preventDefault();

		$thisButton.removeClass( 'success' ).addClass( 'loading' );

		$.post( ajaxurl, {
			action: 'sekhlopress_resekhlo_css_file',
			_nonce: $thisButton.data( 'nonce' ),
		} ).done( function() {
			$thisButton.removeClass( 'loading' ).addClass( 'success' );
		} );
	} );
} );
