<?php
// No direct access, please
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( class_exists( 'WP_Customize_Control' ) && ! class_exists( 'SekhloPress_Title_Customize_Control' ) ) :
/**
 * Create a control to display titles within our sections
 */
class SekhloPress_Title_Customize_Control extends WP_Customize_Control {
	public $type = 'sekhlopress-customizer-title';
	public $title = '';
	
	public function enqueue() {
		wp_enqueue_style( 'sekhlopress-title-customize-control', trailingslashit( plugin_dir_url( __FILE__ ) ) . 'css/title-customizer.css', array(), SEKHLO_CONNECT_ADDON_VERSION );
	}

	public function to_json() {
		parent::to_json();
		$this->json[ 'title' ] = esc_html( $this->title );
	}
	
	public function content_template() {
		?>
		<div class="sekhlopress-customizer-title">
			<span>{{ data.title }}</span>
		</div>
		<?php
	}
}
endif;