<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // No direct access, please.
}

if ( ! class_exists( 'WP_Customize_Control' ) ) {
	return;
}

/**
 * Add a button which needs javascript attached to it.
 */
class SekhloPress_Section_Shortcut_Control extends WP_Customize_Control {
	public $type = 'gp_section_shortcut';
	public $element = '';
	public $shortcuts = array();

	public function enqueue() {
		wp_enqueue_script( 'gp-section-shortcuts', trailingslashit( plugin_dir_url( __FILE__ ) )  . 'js/section-shortcuts.js', array( 'customize-controls' ), SEKHLO_CONNECT_ADDON_VERSION, true );
		wp_enqueue_style( 'gp-section-shortcuts', trailingslashit( plugin_dir_url( __FILE__ ) )  . 'css/section-shortcuts.css', false, SEKHLO_CONNECT_ADDON_VERSION );
	}

	public function to_json() {
		parent::to_json();

		$shortcuts = array();
		foreach( $this->shortcuts as $name => $id ) {
			if ( 'colors' === $name ) {
				$name = esc_html__( 'Colors', 'sekhlopress-connect' );

				if ( version_compare( sekhlo_premium_get_theme_version(), '3.1.0-alpha.1', '>=' ) && 'sekhlo_woocommerce_colors' !== $id ) {
					$id = 'sekhlo_colors_section';
				}

				if ( ! SekhloPress_is_module_active( 'sekhlo_package_colors', 'sekhlo_COLORS' ) ) {
					$id = false;
					$name = false;
				}
			}

			if ( 'typography' === $name ) {
				$name = esc_html__( 'Typography', 'sekhlopress-connect' );

				if ( function_exists( 'sekhlo_is_using_dynamic_typography' ) && sekhlo_is_using_dynamic_typography() ) {
					$id = 'sekhlo_typography_section';
				}

				if ( ! SekhloPress_is_module_active( 'sekhlo_package_typography', 'sekhlo_TYPOGRAPHY' ) ) {
					$id = false;
					$name = false;
				}
			}

			if ( 'backgrounds' === $name ) {
				$name = esc_html__( 'Backgrounds', 'sekhlopress-connect' );

				if ( ! SekhloPress_is_module_active( 'sekhlo_package_backgrounds', 'sekhlo_BACKGROUNDS' ) ) {
					$id = false;
					$name = false;
				}
			}

			if ( 'layout' === $name ) {
				$name = esc_html__( 'Layout', 'sekhlopress-connect' );
			}

			if ( $id && $name ) {
				$shortcuts[ $id ] = $name;
			}
		}

		if ( ! empty( $shortcuts ) ) {
			$this->json['shortcuts'] = $shortcuts;
		} else {
			$this->json['shortcuts'] = false;
		}

		if ( 'WooCommerce' !== $this->element ) {
			$this->element = strtolower( $this->element );
		}

		$this->json['more'] = sprintf(
			__( 'More %s controls:', 'sekhlopress-connect' ),
			'<span class="more-element">' . $this->element . '</span>'
		);

		$this->json['return'] = __( 'Go Back', 'sekhlopress-connect' );

		$this->json['section'] = $this->section;

		if ( apply_filters( 'sekhlo_disable_customizer_shortcuts', false ) ) {
			$this->json['shortcuts'] = false;
		}
	}

	public function content_template() {
		?>
			<div class="sekhlopress-shortcuts">
				<# if ( data.shortcuts ) { #>
					<div class="show-shortcuts">
						<span class="more-controls">
							{{{ data.more }}}
						</span>

						<span class="shortcuts">
							<# _.each( data.shortcuts, function( label, section ) { #>
								<span class="shortcut">
									<a href="#" data-section="{{{ section }}}" data-current-section="{{{ data.section }}}">{{{ label }}}</a>
								</span>
							<# } ) #>
						</span>
					</div>
				<# } #>

				<div class="return-shortcut" style="display: none;">
					<span class="dashicons dashicons-no-alt"></span>
					<a href="#">&larr; {{{ data.return }}}</a>
				</div>
			</div>

		<?php
	}
}
