<?php
// No direct access, please
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_action( 'sekhlo_dashboard_inside_container', 'sekhlo_do_dashboard_tabs', 5 );
add_action( 'sekhlo_inside_site_library_container', 'sekhlo_do_dashboard_tabs', 5 );
add_action( 'sekhlo_before_site_library', 'sekhlo_do_dashboard_tabs', 5 );
/**
 * Adds our tabs to the SekhloPress dashboard.
 *
 * @since 1.6
 */
function sekhlo_do_dashboard_tabs() {
	if ( ! defined( 'sekhlo_VERSION' ) ) {
		return;
	}

	$screen = get_current_screen();

	$tabs = apply_filters( 'sekhlo_dashboard_tabs', array(
		'Modules' => array(
			'name' => __( 'Modules', 'sekhlopress-connect' ),
			'url' => admin_url( 'themes.php?page=sekhlo-options' ),
			'class' => 'appearance_page_sekhlo-options' === $screen->id ? 'active' : '',
		),
	) );

	// Don't print any markup if we only have one tab.
	if ( count( $tabs ) === 1 ) {
		return;
	}
	?>
	<div class="sekhlopress-dashboard-tabs">
		<?php
		foreach ( $tabs as $tab ) {
			printf( '<a href="%1$s" class="%2$s">%3$s</a>',
				esc_url( $tab['url'] ),
				esc_attr( $tab['class'] ),
				esc_html( $tab['name'] )
			);
		}
		?>
	</div>
	<?php
}
