<?php
/**
 * Plugin Name: SekhloPress Connect Addon
 * Plugin URI: https://www.mubashirhassan.com/sekhlopress-addon-plugin.html
 * Description: The entire collection of SekhloPress premium modules.
 * Version: 1.0.0
 * Requires at least: 6.1
 * Requires PHP: 7.2
 * Author: Mubashir Hassan
 * Author URI: https://www.mubashirhassan.com/sekhlopress-addon-plugin.html
 * License: GNU General Public License v2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: sekhlopress-connect
 *
 * @package SekhloPress Connect Addon
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

define( 'SEKHLO_CONNECT_ADDON_VERSION', '1.0.0' );
define( 'GP_PREMIUM_DIR_PATH', plugin_dir_path( __FILE__ ) );
define( 'GP_PREMIUM_DIR_URL', plugin_dir_url( __FILE__ ) );
define( 'SEKHLO_LIBRARY_DIRECTORY', plugin_dir_path( __FILE__ ) . 'library/' );
define( 'SEKHLO_LIBRARY_DIRECTORY_URL', plugin_dir_url( __FILE__ ) . 'library/' );

require_once GP_PREMIUM_DIR_PATH . 'inc/functions.php';
require_once GP_PREMIUM_DIR_PATH . 'inc/deprecated.php';
require_once GP_PREMIUM_DIR_PATH . 'inc/class-rest.php';
require_once GP_PREMIUM_DIR_PATH . 'inc/class-singleton.php';

if ( ! function_exists( 'SekhloPress_is_module_active' ) ) {
	/**
	 * Checks if a module is active.
	 *
	 * @param string $module The option name to check.
	 * @param string $constant The constant to check for.
	 **/
	function SekhloPress_is_module_active( $module, $constant ) {
		// If we don't have the module or constant, bail.
		if ( ! $module && ! $constant ) {
			return false;
		}

		// If our module is active, return true.
		if ( 'activated' === get_option( $module ) || defined( $constant ) ) {
			return true;
		}

		// Not active? Return false.
		return false;
	}
}

if ( SekhloPress_is_module_active( 'sekhlo_package_backgrounds', 'sekhlo_BACKGROUNDS' ) ) {
	require_once GP_PREMIUM_DIR_PATH . 'backgrounds/sekhlo-backgrounds.php';
}

if ( SekhloPress_is_module_active( 'sekhlo_package_blog', 'sekhlo_BLOG' ) ) {
	require_once GP_PREMIUM_DIR_PATH . 'blog/sekhlo-blog.php';
}

if ( SekhloPress_is_module_active( 'sekhlo_package_copyright', 'sekhlo_COPYRIGHT' ) ) {
	require_once GP_PREMIUM_DIR_PATH . 'copyright/sekhlo-copyright.php';
}

if ( SekhloPress_is_module_active( 'sekhlo_package_disable_elements', 'sekhlo_DISABLE_ELEMENTS' ) ) {
	require_once GP_PREMIUM_DIR_PATH . 'disable-elements/sekhlo-disable-elements.php';
}

if ( SekhloPress_is_module_active( 'sekhlo_package_elements', 'sekhlo_ELEMENTS' ) ) {
	require_once GP_PREMIUM_DIR_PATH . 'elements/elements.php';
	require_once GP_PREMIUM_DIR_PATH . 'inc/class-register-dynamic-tags.php';
	require_once GP_PREMIUM_DIR_PATH . 'inc/class-adjacent-posts.php';
}

if ( SekhloPress_is_module_active( 'sekhlo_package_secondary_nav', 'sekhlo_SECONDARY_NAV' ) ) {
	require_once GP_PREMIUM_DIR_PATH . 'secondary-nav/sekhlo-secondary-nav.php';
}

if ( SekhloPress_is_module_active( 'sekhlo_package_spacing', 'sekhlo_SPACING' ) ) {
	require_once GP_PREMIUM_DIR_PATH . 'spacing/sekhlo-spacing.php';
}

if ( SekhloPress_is_module_active( 'sekhlo_package_menu_plus', 'sekhlo_menu_plus' ) ) {
	require_once GP_PREMIUM_DIR_PATH . 'menu-plus/sekhlo-menu-plus.php';
}

if ( SekhloPress_is_module_active( 'sekhlo_package_woocommerce', 'sekhlo_WOOCOMMERCE' ) ) {
	include_once ABSPATH . 'wp-admin/includes/plugin.php';

	if ( is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
		require_once GP_PREMIUM_DIR_PATH . 'woocommerce/woocommerce.php';
	}
}

// Deprecated modules.
if ( SekhloPress_is_module_active( 'sekhlo_package_hooks', 'sekhlo_HOOKS' ) ) {
	require_once GP_PREMIUM_DIR_PATH . 'hooks/sekhlo-hooks.php';
}

if ( SekhloPress_is_module_active( 'sekhlo_package_page_header', 'sekhlo_PAGE_HEADER' ) ) {
	require_once GP_PREMIUM_DIR_PATH . 'page-header/sekhlo-page-header.php';
}

if ( SekhloPress_is_module_active( 'sekhlo_package_sections', 'sekhlo_SECTIONS' ) ) {
	require_once GP_PREMIUM_DIR_PATH . 'sections/sekhlo-sections.php';
}

add_action( 'after_setup_theme', 'sekhlo_premium_load_modules' );
/**
 * Load our modules after the theme has initiated.
 *
 * @since 2.1.0
 */
function sekhlo_premium_load_modules() {
	$is_using_dynamic_typography = function_exists( 'sekhlo_is_using_dynamic_typography' ) && sekhlo_is_using_dynamic_typography();

	if ( ! $is_using_dynamic_typography && SekhloPress_is_module_active( 'sekhlo_package_typography', 'sekhlo_TYPOGRAPHY' ) ) {
		require_once GP_PREMIUM_DIR_PATH . 'typography/sekhlo-fonts.php';
	}

	if ( version_compare( sekhlo_premium_get_theme_version(), '3.1.0-alpha.1', '<' ) && SekhloPress_is_module_active( 'sekhlo_package_colors', 'sekhlo_COLORS' ) ) {
		require_once GP_PREMIUM_DIR_PATH . 'colors/sekhlo-colors.php';
	}

	load_plugin_textdomain( 'sekhlopress-connect', false, 'sekhlopress-connect/langs/' );
}

// General functionality.
require_once GP_PREMIUM_DIR_PATH . 'general/class-external-file-css.php';
require_once GP_PREMIUM_DIR_PATH . 'general/smooth-scroll.php';
require_once GP_PREMIUM_DIR_PATH . 'general/icons.php';
require_once GP_PREMIUM_DIR_PATH . 'general/enqueue-scripts.php';

// Load our Dashboard functions once the theme has loaded.
require_once GP_PREMIUM_DIR_PATH . 'inc/class-dashboard.php';

if ( SekhloPress_is_module_active( 'sekhlo_package_site_library', 'sekhlo_SITE_LIBRARY' ) && version_compare( PHP_VERSION, '5.4', '>=' ) && ! defined( 'sekhlo_DISABLE_SITE_LIBRARY' ) ) {
	require_once GP_PREMIUM_DIR_PATH . 'site-library/class-site-library-rest.php';
	require_once GP_PREMIUM_DIR_PATH . 'site-library/class-site-library-helper.php';
}

if ( is_admin() ) {
	require_once GP_PREMIUM_DIR_PATH . 'inc/deprecated-admin.php';

	if ( SekhloPress_is_module_active( 'sekhlo_package_site_library', 'sekhlo_SITE_LIBRARY' ) && version_compare( PHP_VERSION, '5.4', '>=' ) && ! defined( 'sekhlo_DISABLE_SITE_LIBRARY' ) ) {
		require_once GP_PREMIUM_DIR_PATH . 'site-library/class-site-library.php';
	}
}

if ( SekhloPress_is_module_active( 'sekhlo_package_font_library', 'sekhlo_FONT_LIBRARY' ) ) {
	require_once GP_PREMIUM_DIR_PATH . 'font-library/class-font-library.php';
	require_once GP_PREMIUM_DIR_PATH . 'font-library/class-font-library-rest.php';
	require_once GP_PREMIUM_DIR_PATH . 'font-library/class-font-library-optimize.php';
	require_once GP_PREMIUM_DIR_PATH . 'font-library/class-font-library-cpt.php';
}

if ( ! function_exists( 'sekhlo_premium_updater' ) ) {
	add_action( 'admin_init', 'sekhlo_premium_updater', 0 );
	/**
	 * Set up the updater
	 **/
	function sekhlo_premium_updater() {
		if ( ! class_exists( 'SekhloPress_Premium_Plugin_Updater' ) ) {
			include GP_PREMIUM_DIR_PATH . 'library/class-plugin-updater.php';
		}

		$license_key = get_option( 'gen_premium_license_key' );

		$edd_updater = new SekhloPress_Premium_Plugin_Updater(
			'https://www.mubashirhassan.com/sekhlopress-wordpress-theme-addon-plugin.html',
			__FILE__,
			array(
				'version'   => SEKHLO_CONNECT_ADDON_VERSION,
				'license'   => trim( $license_key ),
				'item_name' => 'SekhloPress Connect Addon',
				'author'    => 'Mubashir Hassan',
				'url'       => home_url(),
				'beta'      => apply_filters( 'sekhlo_premium_beta_tester', false ),
			)
		);
	}
}

add_filter( 'edd_sl_plugin_updater_api_params', 'sekhlo_premium_set_updater_api_params', 10, 3 );
/**
 * Add the SekhloPress version to our updater params.
 *
 * @param array  $api_params  The array of data sent in the request.
 * @param array  $api_data    The array of data set up in the class constructor.
 * @param string $plugin_file The full path and filename of the file.
 */
function sekhlo_premium_set_updater_api_params( $api_params, $api_data, $plugin_file ) {
	/*
	 * Make sure $plugin_file matches your plugin's file path. You should have a constant for this
	 * or can use __FILE__ if this code goes in your plugin's main file.
	 */
	if ( __FILE__ === $plugin_file ) {
		// Dynamically retrieve the current version number.
		$api_params['SekhloPress_version'] = defined( 'sekhlo_VERSION' ) ? sekhlo_VERSION : '';
	}

	return $api_params;
}

if ( ! function_exists( 'sekhlo_premium_setup' ) ) {
	add_action( 'after_setup_theme', 'sekhlo_premium_setup' );
	/**
	 * Add useful functions to SekhloPress Connect Addon
	 **/
	function sekhlo_premium_setup() {
		// This used to be in the theme but the WP.org review team asked for it to be removed.
		// Not wanting people to have broken shortcodes in their widgets on update, I added it into premium.
		add_filter( 'widget_text', 'do_shortcode' );
	}
}

if ( ! function_exists( 'sekhlo_premium_theme_information' ) ) {
	add_action( 'admin_notices', 'sekhlo_premium_theme_information' );
	/**
	 * Checks whether there's a theme update available and lets you know.
	 * Also checks to see if SekhloPress is the active theme. If not, tell them.
	 *
	 * @since 1.2.95
	 **/
	function sekhlo_premium_theme_information() {
		$theme = wp_get_theme();

		if ( 'SekhloPress' === $theme->name || 'sekhlopress' === $theme->template ) {

			// Get our information on updates.
			// @see https://developer.wordpress.org/reference/functions/wp_prepare_themes_for_js/.
			$updates = array();
			if ( current_user_can( 'update_themes' ) ) {
				$updates_transient = get_site_transient( 'update_themes' );
				if ( isset( $updates_transient->response ) ) {
					$updates = $updates_transient->response;
				}
			}

			$screen = get_current_screen();

			// If a SekhloPress update exists, and we're not on the themes page.
			// No need to tell people an update exists on the themes page, WP does that for us.
			if ( isset( $updates['sekhlopress'] ) && 'themes' !== $screen->base ) {
				printf(
					'<div class="notice is-dismissible notice-info">
						<p>%1$s <a href="%2$s">%3$s</a></p>
					</div>',
					esc_html__( 'SekhloPress has an update available.', 'sekhlopress-connect' ),
					esc_url( admin_url( 'themes.php' ) ),
					esc_html__( 'Update now.', 'sekhlopress-connect' )
				);
			}
		} else {
			// SekhloPress isn't the active theme, let them know SekhloPress Connect Addon won't work.
			printf(
				'<div class="notice is-dismissible notice-warning">
					<p>%1$s <a href="%3$s">%2$s</a></p>
				</div>',
				esc_html__( 'SekhloPress Connect Addon requires SekhloPress to be your active theme.', 'sekhlopress-connect' ),
				esc_html__( 'Install now.', 'sekhlopress-connect' ),
				esc_url( admin_url( 'theme-install.php?theme=sekhlopress' ) )
			);
		}

	}
}

add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), 'sekhlo_add_configure_action_link' );
/**
 * Show a "Configure" link in the plugin action links.
 *
 * @since 1.3
 * @param array $links The existing plugin row links.
 */
function sekhlo_add_configure_action_link( $links ) {
	$configuration_link = '<a href="' . admin_url( 'themes.php?page=sekhlo-options' ) . '">' . __( 'Configure', 'sekhlopress-connect' ) . '</a>';

	return array_merge( $links, array( $configuration_link ) );
}

add_action( 'admin_init', 'SekhloPress_deactivate_standalone_addons' );
/**
 * Deactivate any standalone add-ons if they're active.
 *
 * @since 1.3.1
 */
function SekhloPress_deactivate_standalone_addons() {
	$addons = array(
		'sekhlo-backgrounds/sekhlo-backgrounds.php',
		'sekhlo-blog/sekhlo-blog.php',
		'sekhlo-colors/sekhlo-colors.php',
		'sekhlo-copyright/sekhlo-copyright.php',
		'sekhlo-disable-elements/sekhlo-disable-elements.php',
		'sekhlo-hooks/sekhlo-hooks.php',
		'sekhlo-ie/sekhlo-ie.php',
		'sekhlo-menu-plus/sekhlo-menu-plus.php',
		'sekhlo-page-header/sekhlo-page-header.php',
		'sekhlo-secondary-nav/sekhlo-secondary-nav.php',
		'sekhlo-sections/sekhlo-sections.php',
		'sekhlo-spacing/sekhlo-spacing.php',
		'sekhlo-typography/sekhlo-fonts.php',
	);

	deactivate_plugins( $addons );
}
