<?php
/**
 * This file handles SVG icons.
 *
 * @package SekhloPress Connect Addon
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // No direct access, please.
}

add_action( 'wp_enqueue_scripts', 'sekhlo_enqueue_premium_icons' );
/**
 * Register our SekhloPress Connect Addon icons.
 *
 * @since 1.6
 */
function sekhlo_enqueue_premium_icons() {
	$suffix = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';

	wp_register_style( 'sekhlopress-connect-icons', plugin_dir_url( __FILE__ ) . "icons/icons{$suffix}.css", array(), SEKHLO_CONNECT_ADDON_VERSION );
}

add_filter( 'sekhlo_svg_icon', 'sekhlo_premium_add_svg_icons', 10, 2 );
/**
 * Add our premium SVG icons.
 *
 * @since 1.9
 * @param string $output The SVG HTML output.
 * @param string $icon The icon name.
 */
function sekhlo_premium_add_svg_icons( $output, $icon ) {
	$svg = '';

	if ( 'shopping-bag' === $icon ) {
		$svg = '<svg viewBox="0 0 518 512" aria-hidden="true" version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em">
		    <g id="Union" transform="matrix(1,0,0,1,2.01969,2)">
		        <path d="M172,108.5C172,61.832 209.832,24 256.5,24C303.168,24 341,61.832 341,108.5L341,116C341,122.627 346.373,128 353,128C359.628,128 365,122.627 365,116L365,108.5C365,48.577 316.423,0 256.5,0C196.577,0 148,48.577 148,108.5L148,116C148,122.627 153.373,128 160,128C166.628,128 172,122.627 172,116L172,108.5Z" style="fill-rule:nonzero;"/>
		        <path d="M4.162,145.236C7.195,141.901 11.493,140 16,140L496,140C500.507,140 504.806,141.901 507.838,145.236C510.87,148.571 512.355,153.03 511.928,157.517L482.687,464.551C480.34,489.186 459.65,508 434.903,508L77.097,508C52.35,508 31.66,489.186 29.314,464.551L0.072,157.517C-0.355,153.03 1.13,148.571 4.162,145.236Z" style="fill-rule:nonzero;"/>
		    </g>
		</svg>';
	}

	if ( 'shopping-cart' === $icon ) {
		$svg = '<svg viewBox="0 0 576 512" aria-hidden="true" version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em">
				<path fill="none" d="M0 0h576v512H0z"/>
				<path d="M181.54 409.6c-29.249 0-52.914 23.04-52.914 51.2 0 28.16 23.665 51.2 52.915 51.2 29.249 0 53.18-23.04 53.18-51.2 0-28.16-23.931-51.2-53.18-51.2zM22 0v51.2h53.18l95.725 194.304-35.897 62.464C115.598 342.272 141.124 384 181.54 384h319.08v-51.2h-319.08l29.249-51.2h198.096c19.943 0 37.492-10.496 46.533-26.368L550.61 89.088c9.838-16.896-2.925-37.888-23.133-37.888H133.944L108.95 0H22zm425.442 409.6c-29.25 0-52.915 23.04-52.915 51.2 0 28.16 23.665 51.2 52.915 51.2 29.249 0 53.18-23.04 53.18-51.2 0-28.16-23.931-51.2-53.18-51.2z"/>
			</svg>';
	}

	if ( 'shopping-basket' === $icon ) {
		$svg = '<svg viewBox="0 0 626 512" aria-hidden="true" version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em">
				<path d="M4.83 187.075a19.505 19.505 0 0 1 14.675-6.656h585.144a19.505 19.505 0 0 1 19.334 22.083L589.486 461.22c-3.875 29.07-28.672 50.781-58 50.781H92.668c-29.328 0-54.126-21.71-58.002-50.78L.171 202.501a19.511 19.511 0 0 1 4.659-15.427zm165.748 69.748c-.892-8.03-8.125-13.815-16.155-12.924-8.03.892-13.815 8.125-12.924 16.155l19.505 175.543c.892 8.03 8.125 13.816 16.154 12.924 8.03-.892 13.816-8.125 12.925-16.154l-19.505-175.544zm312.077 3.23c.892-8.029-4.895-15.262-12.925-16.154-8.03-.891-15.262 4.894-16.154 12.924L434.07 432.367c-.893 8.03 4.894 15.262 12.924 16.154 8.03.892 15.263-4.894 16.155-12.924l19.505-175.543zm-153.512-1.614c0-8.079-6.55-14.629-14.628-14.629-8.079 0-14.629 6.55-14.629 14.629v175.543c0 8.078 6.55 14.628 14.629 14.628s14.628-6.55 14.628-14.628V258.439z"/>
				<path d="M283.41 4.285c5.715 5.712 5.715 14.975 0 20.687L146.878 161.506c-5.712 5.714-14.975 5.714-20.687 0-5.714-5.713-5.714-14.975 0-20.687L262.724 4.285c5.712-5.714 14.974-5.714 20.687 0zm57.333 0c5.712-5.714 14.975-5.714 20.687 0l136.534 136.534c5.713 5.712 5.713 14.974 0 20.687-5.713 5.714-14.975 5.714-20.688 0L340.743 24.972c-5.714-5.712-5.714-14.975 0-20.687z" />
			</svg>';
	}

	if ( 'spinner' === $icon ) {
		$svg = '<svg viewBox="0 0 512 512" aria-hidden="true" version="1.1" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em">
					<path d="M288 32c0 17.673-14.327 32-32 32-17.673 0-32-14.327-32-32 0-17.673 14.327-32 32-32 17.673 0 32 14.327 32 32zM288 480c0 17.673-14.327 32-32 32-17.673 0-32-14.327-32-32 0-17.673 14.327-32 32-32 17.673 0 32 14.327 32 32zM448 256c0 17.673 14.327 32 32 32 17.673 0 32-14.327 32-32 0-17.673-14.327-32-32-32-17.673 0-32 14.327-32 32zM32 288c-17.673 0-32-14.327-32-32 0-17.673 14.327-32 32-32 17.673 0 32 14.327 32 32 0 17.673-14.327 32-32 32zM391.764 391.764c-12.496 12.497-12.496 32.759 0 45.255 12.497 12.497 32.758 12.497 45.255 0 12.497-12.496 12.497-32.758 0-45.255-12.497-12.496-32.758-12.496-45.255 0zM74.981 120.235c-12.497-12.496-12.497-32.758 0-45.254 12.496-12.497 32.758-12.497 45.254 0 12.497 12.496 12.497 32.758 0 45.254-12.496 12.497-32.758 12.497-45.254 0zM120.235 391.765c-12.496-12.497-32.758-12.497-45.254 0-12.497 12.496-12.497 32.758 0 45.254 12.496 12.497 32.758 12.497 45.254 0 12.497-12.496 12.497-32.758 0-45.254z"/>
				</svg>';
	}

	if ( 'pro-menu-bars' === $icon ) {
		$svg = '<svg viewBox="0 0 512 512" aria-hidden="true" role="img" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="1em" height="1em">
					<path d="M0 96c0-13.255 10.745-24 24-24h464c13.255 0 24 10.745 24 24s-10.745 24-24 24H24c-13.255 0-24-10.745-24-24zm0 160c0-13.255 10.745-24 24-24h464c13.255 0 24 10.745 24 24s-10.745 24-24 24H24c-13.255 0-24-10.745-24-24zm0 160c0-13.255 10.745-24 24-24h464c13.255 0 24 10.745 24 24s-10.745 24-24 24H24c-13.255 0-24-10.745-24-24z" />
				</svg>';
	}

	if ( 'pro-close' === $icon ) {
		$svg = '<svg viewBox="0 0 512 512" aria-hidden="true" role="img" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="1em" height="1em">
					<path d="M71.029 71.029c9.373-9.372 24.569-9.372 33.942 0L256 222.059l151.029-151.03c9.373-9.372 24.569-9.372 33.942 0 9.372 9.373 9.372 24.569 0 33.942L289.941 256l151.03 151.029c9.372 9.373 9.372 24.569 0 33.942-9.373 9.372-24.569 9.372-33.942 0L256 289.941l-151.029 151.03c-9.373 9.372-24.569 9.372-33.942 0-9.372-9.373-9.372-24.569 0-33.942L222.059 256 71.029 104.971c-9.372-9.373-9.372-24.569 0-33.942z" />
				</svg>';
	}

	if ( $svg ) {
		$output = sprintf(
			'<span class="gp-icon %1$s">
				%2$s
			</span>',
			$icon,
			$svg
		);
	}

	return $output;
}
