<?php
/**
 * This file handles the Customizer options for the Off-Canvas Panel.
 *
 * @package SekhloPress Connect Addon
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // No direct access, please.
}

add_action( 'customize_preview_init', 'sekhlo_menu_plus_live_preview_scripts', 20 );
/**
 * Add live preview JS to the Customizer.
 */
function sekhlo_menu_plus_live_preview_scripts() {
	wp_enqueue_script( 'sekhlo-menu-plus-colors-customizer' );
}

add_action( 'customize_register', 'sekhlo_slideout_navigation_color_controls', 150 );
/**
 * Adds our Slideout Nav color options
 *
 * @since 1.6
 * @param object $wp_customize The Customizer object.
 */
function sekhlo_slideout_navigation_color_controls( $wp_customize ) {
	// Bail if Secondary Nav isn't activated.
	if ( ! $wp_customize->get_section( 'menu_plus_slideout_menu' ) ) {
		return;
	}

	// Bail if we don't have our color defaults.
	if ( ! function_exists( 'sekhlo_get_color_defaults' ) ) {
		return;
	}

	// Add our controls.
	require_once SEKHLO_LIBRARY_DIRECTORY . 'customizer-helpers.php';

	// Get our defaults.
	$defaults = sekhlo_get_color_defaults();

	// Add control types so controls can be built using JS.
	if ( method_exists( $wp_customize, 'register_control_type' ) ) {
		$wp_customize->register_control_type( 'SekhloPress_Alpha_Color_Customize_Control' );
		$wp_customize->register_control_type( 'SekhloPress_Section_Shortcut_Control' );
	}

	// Get our palettes.
	$palettes = sekhlo_get_default_color_palettes();

	// Add Secondary Navigation section.
	$wp_customize->add_section(
		'slideout_color_section',
		array(
			'title' => __( 'Off Canvas Panel', 'sekhlopress-connect' ),
			'capability' => 'edit_theme_options',
			'priority' => 73,
			'panel' => 'sekhlo_colors_panel',
		)
	);

	$wp_customize->add_control(
		new SekhloPress_Section_Shortcut_Control(
			$wp_customize,
			'sekhlo_off_canvas_color_shortcuts',
			array(
				'section' => 'slideout_color_section',
				'element' => __( 'Off Canvas Panel', 'sekhlopress-connect' ),
				'shortcuts' => array(
					'layout' => 'menu_plus_slideout_menu',
					'typography' => 'sekhlo_slideout_typography',
				),
				'settings' => ( isset( $wp_customize->selective_refresh ) ) ? array() : 'blogname',
				'priority' => 1,
			)
		)
	);

	$wp_customize->add_control(
		new SekhloPress_Title_Customize_Control(
			$wp_customize,
			'sekhlo_slideout_navigation_items',
			array(
				'section'  => 'slideout_color_section',
				'type'     => 'sekhlopress-customizer-title',
				'title'    => __( 'Parent Menu Items', 'sekhlopress-connect' ),
				'settings' => ( isset( $wp_customize->selective_refresh ) ) ? array() : 'blogname',
			)
		)
	);

	// Background.
	$wp_customize->add_setting(
		'sekhlo_settings[slideout_background_color]',
		array(
			'default' => $defaults['slideout_background_color'],
			'type' => 'option',
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'sekhlo_premium_sanitize_rgba',
			'transport' => 'postMessage',
		)
	);

	$wp_customize->add_control(
		new SekhloPress_Alpha_Color_Customize_Control(
			$wp_customize,
			'sekhlo_settings[slideout_background_color]',
			array(
				'label' => __( 'Background', 'sekhlopress-connect' ),
				'section' => 'slideout_color_section',
				'settings' => 'sekhlo_settings[slideout_background_color]',
				'palette'   => $palettes,
			)
		)
	);

	// Text.
	$wp_customize->add_setting(
		'sekhlo_settings[slideout_text_color]',
		array(
			'default' => $defaults['slideout_text_color'],
			'type' => 'option',
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'sekhlo_premium_sanitize_hex_color',
			'transport' => 'postMessage',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekhlo_settings[slideout_text_color]',
			array(
				'label' => __( 'Text', 'sekhlopress-connect' ),
				'section' => 'slideout_color_section',
				'settings' => 'sekhlo_settings[slideout_text_color]',
			)
		)
	);

	// Background hover.
	$wp_customize->add_setting(
		'sekhlo_settings[slideout_background_hover_color]',
		array(
			'default' => $defaults['slideout_background_hover_color'],
			'type' => 'option',
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'sekhlo_premium_sanitize_rgba',
			'transport' => 'postMessage',
		)
	);

	$wp_customize->add_control(
		new SekhloPress_Alpha_Color_Customize_Control(
			$wp_customize,
			'sekhlo_settings[slideout_background_hover_color]',
			array(
				'label' => __( 'Background Hover', 'sekhlopress-connect' ),
				'section' => 'slideout_color_section',
				'settings' => 'sekhlo_settings[slideout_background_hover_color]',
				'palette'   => $palettes,
			)
		)
	);

	// Text hover.
	$wp_customize->add_setting(
		'sekhlo_settings[slideout_text_hover_color]',
		array(
			'default' => $defaults['slideout_text_hover_color'],
			'type' => 'option',
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'sekhlo_premium_sanitize_hex_color',
			'transport' => 'postMessage',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekhlo_settings[slideout_text_hover_color]',
			array(
				'label' => __( 'Text Hover', 'sekhlopress-connect' ),
				'section' => 'slideout_color_section',
				'settings' => 'sekhlo_settings[slideout_text_hover_color]',
			)
		)
	);

	// Background current.
	$wp_customize->add_setting(
		'sekhlo_settings[slideout_background_current_color]',
		array(
			'default' => $defaults['slideout_background_current_color'],
			'type' => 'option',
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'sekhlo_premium_sanitize_rgba',
			'transport' => 'postMessage',
		)
	);

	$wp_customize->add_control(
		new SekhloPress_Alpha_Color_Customize_Control(
			$wp_customize,
			'sekhlo_settings[slideout_background_current_color]',
			array(
				'label' => __( 'Background Current', 'sekhlopress-connect' ),
				'section' => 'slideout_color_section',
				'settings' => 'sekhlo_settings[slideout_background_current_color]',
				'palette'   => $palettes,
			)
		)
	);

	// Text current.
	$wp_customize->add_setting(
		'sekhlo_settings[slideout_text_current_color]',
		array(
			'default' => $defaults['slideout_text_current_color'],
			'type' => 'option',
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'sekhlo_premium_sanitize_hex_color',
			'transport' => 'postMessage',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekhlo_settings[slideout_text_current_color]',
			array(
				'label' => __( 'Text Current', 'sekhlopress-connect' ),
				'section' => 'slideout_color_section',
				'settings' => 'sekhlo_settings[slideout_text_current_color]',
			)
		)
	);

	$wp_customize->add_control(
		new SekhloPress_Title_Customize_Control(
			$wp_customize,
			'sekhlo_slideout_navigation_sub_menu_items',
			array(
				'section'  => 'slideout_color_section',
				'type'     => 'sekhlopress-customizer-title',
				'title'    => __( 'Sub-Menu Items', 'sekhlopress-connect' ),
				'settings' => ( isset( $wp_customize->selective_refresh ) ) ? array() : 'blogname',
			)
		)
	);

	// Background.
	$wp_customize->add_setting(
		'sekhlo_settings[slideout_submenu_background_color]',
		array(
			'default' => $defaults['slideout_submenu_background_color'],
			'type' => 'option',
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'sekhlo_premium_sanitize_rgba',
			'transport' => 'postMessage',
		)
	);

	$wp_customize->add_control(
		new SekhloPress_Alpha_Color_Customize_Control(
			$wp_customize,
			'sekhlo_settings[slideout_submenu_background_color]',
			array(
				'label' => __( 'Background', 'sekhlopress-connect' ),
				'section' => 'slideout_color_section',
				'settings' => 'sekhlo_settings[slideout_submenu_background_color]',
				'palette'   => $palettes,
			)
		)
	);

	// Text.
	$wp_customize->add_setting(
		'sekhlo_settings[slideout_submenu_text_color]',
		array(
			'default' => $defaults['slideout_submenu_text_color'],
			'type' => 'option',
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'sekhlo_premium_sanitize_hex_color',
			'transport' => 'postMessage',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekhlo_settings[slideout_submenu_text_color]',
			array(
				'label' => __( 'Text', 'sekhlopress-connect' ),
				'section' => 'slideout_color_section',
				'settings' => 'sekhlo_settings[slideout_submenu_text_color]',
			)
		)
	);

	// Background hover.
	$wp_customize->add_setting(
		'sekhlo_settings[slideout_submenu_background_hover_color]',
		array(
			'default' => $defaults['slideout_submenu_background_hover_color'],
			'type' => 'option',
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'sekhlo_premium_sanitize_rgba',
			'transport' => 'postMessage',
		)
	);

	$wp_customize->add_control(
		new SekhloPress_Alpha_Color_Customize_Control(
			$wp_customize,
			'sekhlo_settings[slideout_submenu_background_hover_color]',
			array(
				'label' => __( 'Background Hover', 'sekhlopress-connect' ),
				'section' => 'slideout_color_section',
				'settings' => 'sekhlo_settings[slideout_submenu_background_hover_color]',
				'palette'   => $palettes,
			)
		)
	);

	// Text hover.
	$wp_customize->add_setting(
		'sekhlo_settings[slideout_submenu_text_hover_color]',
		array(
			'default' => $defaults['slideout_submenu_text_hover_color'],
			'type' => 'option',
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'sekhlo_premium_sanitize_hex_color',
			'transport' => 'postMessage',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekhlo_settings[slideout_submenu_text_hover_color]',
			array(
				'label' => __( 'Text Hover', 'sekhlopress-connect' ),
				'section' => 'slideout_color_section',
				'settings' => 'sekhlo_settings[slideout_submenu_text_hover_color]',
			)
		)
	);

	// Background current.
	$wp_customize->add_setting(
		'sekhlo_settings[slideout_submenu_background_current_color]',
		array(
			'default' => $defaults['slideout_submenu_background_current_color'],
			'type' => 'option',
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'sekhlo_premium_sanitize_rgba',
			'transport' => 'postMessage',
		)
	);

	$wp_customize->add_control(
		new SekhloPress_Alpha_Color_Customize_Control(
			$wp_customize,
			'sekhlo_settings[slideout_submenu_background_current_color]',
			array(
				'label' => __( 'Background Current', 'sekhlopress-connect' ),
				'section' => 'slideout_color_section',
				'settings' => 'sekhlo_settings[slideout_submenu_background_current_color]',
				'palette'   => $palettes,
			)
		)
	);

	// Text current.
	$wp_customize->add_setting(
		'sekhlo_settings[slideout_submenu_text_current_color]',
		array(
			'default' => $defaults['slideout_submenu_text_current_color'],
			'type' => 'option',
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'sekhlo_premium_sanitize_hex_color',
			'transport' => 'postMessage',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'sekhlo_settings[slideout_submenu_text_current_color]',
			array(
				'label' => __( 'Text Current', 'sekhlopress-connect' ),
				'section' => 'slideout_color_section',
				'settings' => 'sekhlo_settings[slideout_submenu_text_current_color]',
			)
		)
	);
}
