<?php
/**
 * Meta Box Template
 */
?>
<div class="sekhlo-schema-wrapper">
    
    <div class="sekhlo-header">
        <div class="sekhlo-tabs">
            <div class="sekhlo-tab active" data-tab="sekhlo_schemas">Schemas</div>
            <div class="sekhlo-tab" data-tab="sekhlo_ai_prompt">Prompt Generator</div>
            <div class="sekhlo-tab" data-tab="sekhlo_internal_links">Internal Links</div>
            <div class="sekhlo-tab" data-tab="sekhlo_meta_seo">Meta Title & Description</div>
            <div class="sekhlo-tab" data-tab="sekhlo_templates">Templates</div>
            <div class="sekhlo-tab" data-tab="sekhlo_preview">Preview</div>
            <div class="sekhlo-tab" data-tab="sekhlo_testing">Testing</div>
        </div>
    </div>

    <div class="sekhlo-content">
        
        <!-- Schemas Tab -->
        <div id="sekhlo_schemas" class="sekhlo-tab-content active">
            
            <!-- Schema List (will show bulk actions when schemas exist) -->
            <div id="sekhlo-schema-list-container" class="sekhlo-schema-list">
                <!-- JS will render schemas here -->
            </div>
            
            <!-- Add New Schema Box -->
            <div class="sekhlo-add-schema-box">
                <div class="sekhlo-add-box-header">
                    <span class="dashicons dashicons-plus-alt2"></span>
                    <span>Add Schema</span>
                </div>
                <div class="sekhlo-add-box-body">
                    <div class="sekhlo-form-row">
                        <label>Schema Name</label>
                        <input type="text" id="sekhlo-quick-paste-name" class="sekhlo-input" placeholder="e.g. Organization Schema">
                    </div>
                    
                    <div class="sekhlo-form-row">
                        <label>Paste JSON-LD Code</label>
                        <textarea id="sekhlo-quick-paste-json" class="sekhlo-code-editor" placeholder='Paste your JSON-LD code here or leave empty to create a blank schema'></textarea>
                        <div id="sekhlo-quick-paste-validation" class="validation-msg"></div>
                    </div>

                    <div class="sekhlo-add-box-footer">
                        <button type="button" id="add-new-schema" class="sekhlo-btn sekhlo-btn-primary">
                            <span class="dashicons dashicons-plus"></span> Add Schema
                        </button>
                        <span class="sekhlo-divider-text">or</span>
                        <a href="#" class="sekhlo-link-btn" data-action="go-templates">
                            <span class="dashicons dashicons-layout"></span> Browse Templates
                        </a>
                        <span class="sekhlo-divider-text">or</span>
                        <button type="button" id="sekhlo-generate-ai-prompt" class="sekhlo-btn sekhlo-btn-ai">
                            <span class="dashicons dashicons-admin-generic"></span> Generate AI Prompt
                        </button>
                    </div>
                </div>
            </div>
            
            <!-- Hidden file input for import -->
            <input type="file" id="sekhlo-import-file" style="display:none;" accept=".json">
            
            <!-- Hidden field to store schema data -->
            <?php 
            // Ensure schemas is properly encoded for HTML attribute
            $schemas_json = wp_json_encode($schemas);
            if ($schemas_json === false) {
                $schemas_json = '[]';
            }
            ?>
            <input type="hidden" name="sekhlo_schemas_json" id="sekhlo_schemas_json" value="<?php echo htmlspecialchars($schemas_json, ENT_QUOTES, 'UTF-8'); ?>">
        </div>

        <!-- Internal Links Tab -->
        <div id="sekhlo_internal_links" class="sekhlo-tab-content">
            <div style="background:#f9fafb; padding:20px; border-radius:8px; margin-bottom:20px; border: 1px solid #e5e7eb;">
                <h4 style="margin-top:0; color:#111827;">Internal Link Suggestions</h4>
                <p style="font-size:13px; color:#6b7280; margin-bottom:20px;">Relevant posts from your site to strengthen internal linking.</p>
                
                <div id="sekhlo-internal-suggestions-list" class="sekhlo-suggestion-list">
                    <div style="text-align:center; padding:20px;">
                        <span class="spinner is-active" style="float:none;"></span>
                        <p style="color:#6b7280;">Scanning content...</p>
                    </div>
                </div>

                <div style="margin-top:20px; text-align:center; padding-top:20px; border-top:1px solid #e5e7eb;">
                    <button type="button" id="sekhlo-generate-internal-links-prompt" class="sekhlo-btn sekhlo-btn-ai" style="padding:12px 24px;">
                        <span class="dashicons dashicons-admin-generic"></span> Generate AI Prompt for Internal Links
                    </button>
                    <p style="font-size:12px; color:#6b7280; margin-top:8px;">Get AI-powered internal linking suggestions based on your sitemap</p>
                </div>
            </div>

            <div style="background:#ffffff; padding:20px; border-radius:8px; border:1px solid #e5e7eb; margin-bottom:20px; display:none;" id="sekhlo-internal-links-prompt-container">
                <div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:16px;">
                    <h4 style="margin:0; color:#111827; font-size:16px;">Generated Internal Links Prompt</h4>
                    <button type="button" id="sekhlo-copy-internal-links-prompt-btn" class="sekhlo-btn sekhlo-btn-primary">
                        <span class="dashicons dashicons-clipboard"></span> Copy Prompt
                    </button>
                </div>
                
                <textarea id="sekhlo-internal-links-prompt-textarea" readonly class="sekhlo-code-editor" style="min-height:400px; background:#f9fafb; cursor:text; font-size:13px; line-height:1.6;"></textarea>
                
                <div style="display:flex; gap:12px; margin-top:16px; align-items:center; flex-wrap:wrap;">
                    <span id="sekhlo-internal-links-copy-msg" style="color:#10b981; font-weight:600; font-size:13px;"></span>
                    <div style="margin-left:auto; display:flex; gap:8px; flex-wrap:wrap;">
                        <span style="font-size:13px; color:#6b7280; margin-right:8px;">Paste into:</span>
                        <a href="https://chatgpt.com" target="_blank" class="sekhlo-btn" style="text-decoration:none;">
                            <span class="dashicons dashicons-external"></span> ChatGPT
                        </a>
                        <a href="https://gemini.google.com" target="_blank" class="sekhlo-btn" style="text-decoration:none;">
                            <span class="dashicons dashicons-external"></span> Gemini
                        </a>
                        <a href="https://claude.ai" target="_blank" class="sekhlo-btn" style="text-decoration:none;">
                            <span class="dashicons dashicons-external"></span> Claude
                        </a>
                    </div>
                </div>
            </div>
            
            <div style="font-size:12px; color:#6b7280; border-top:1px solid #e5e7eb; padding-top:12px;">
                <strong>Tip:</strong> Internal links improve navigation and help search engines understand your site structure.
            </div>
        </div>

        <!-- Meta Title & Meta Description Tab -->
        <div id="sekhlo_meta_seo" class="sekhlo-tab-content">
            <div style="background:#f9fafb; padding:24px; border-radius:8px; margin-bottom:20px; border: 1px solid #e5e7eb;">
                <h4 style="margin-top:0; color:#111827; display:flex; align-items:center; gap:8px;">
                    <span class="dashicons dashicons-edit" style="color:#2563eb;"></span>
                    SEO Meta Tags
                </h4>
                <p style="font-size:13px; color:#6b7280; margin-bottom:24px;">Customize how your page appears in search results and social media shares.</p>
                
                <div class="sekhlo-form-group" style="margin-bottom:24px;">
                    <label style="display:block; font-weight:600; color:#111827; margin-bottom:8px;">
                        Meta Title
                        <span style="font-weight:400; color:#6b7280; font-size:12px;">(Recommended: 50-60 characters)</span>
                    </label>
                    <input type="text" 
                           name="sekhlo_seo_title" 
                           id="sekhlo_seo_title" 
                           class="sekhlo-input sekhlo-meta-field" 
                           value="<?php echo esc_attr(get_post_meta($post->ID, 'sekhlo_seo_title', true)); ?>" 
                           placeholder="<?php echo esc_attr(get_the_title($post->ID)); ?>"
                           maxlength="70"
                           style="width:100%; padding:12px; border:1px solid #d1d5db; border-radius:6px; font-size:14px;">
                    <div style="display:flex; justify-content:space-between; margin-top:6px;">
                        <span id="sekhlo-title-counter" style="font-size:12px; color:#6b7280;">0 characters</span>
                        <span id="sekhlo-title-status" style="font-size:12px;"></span>
                    </div>
                </div>

                <div class="sekhlo-form-group" style="margin-bottom:24px;">
                    <label style="display:block; font-weight:600; color:#111827; margin-bottom:8px;">
                        Meta Description
                        <span style="font-weight:400; color:#6b7280; font-size:12px;">(Recommended: 150-160 characters)</span>
                    </label>
                    <textarea name="sekhlo_seo_description" 
                              id="sekhlo_seo_description" 
                              class="sekhlo-input sekhlo-meta-field" 
                              rows="4" 
                              placeholder="Write a compelling description that summarizes your content..."
                              maxlength="320"
                              style="width:100%; padding:12px; border:1px solid #d1d5db; border-radius:6px; font-size:14px; resize:vertical;"><?php echo esc_textarea(get_post_meta($post->ID, 'sekhlo_seo_description', true)); ?></textarea>
                    <div style="display:flex; justify-content:space-between; margin-top:6px;">
                        <span id="sekhlo-desc-counter" style="font-size:12px; color:#6b7280;">0 characters</span>
                        <span id="sekhlo-desc-status" style="font-size:12px;"></span>
                    </div>
                </div>

                <div class="sekhlo-form-group" style="margin-bottom:24px;">
                    <label style="display:block; font-weight:600; color:#111827; margin-bottom:8px;">
                        URL Slug
                        <span style="font-weight:400; color:#6b7280; font-size:12px;">(Permalink)</span>
                    </label>
                    <div style="display:flex; align-items:center; gap:8px; background:#ffffff; padding:12px; border:1px solid #d1d5db; border-radius:6px;">
                        <span style="font-size:13px; color:#6b7280;"><?php echo esc_html(trailingslashit(home_url())); ?></span>
                        <input type="text" 
                               name="sekhlo_post_slug" 
                               id="sekhlo_post_slug" 
                               class="sekhlo-meta-field"
                               value="<?php echo esc_attr($post->post_name); ?>" 
                               placeholder="<?php echo esc_attr(sanitize_title(get_the_title($post->ID))); ?>"
                               style="flex:1; padding:6px 10px; border:1px solid #d1d5db; border-radius:4px; font-size:13px; font-family:monospace;">
                    </div>
                    <div style="margin-top:6px; font-size:12px; color:#6b7280;">
                        <span class="dashicons dashicons-info" style="font-size:14px; width:14px; height:14px; vertical-align:middle;"></span>
                        Use lowercase letters, numbers, and hyphens only. Avoid special characters.
                    </div>
                </div>

                <div style="background:#eff6ff; padding:16px; border-radius:6px; border-left:4px solid #2563eb;">
                    <div style="display:flex; gap:12px;">
                        <span class="dashicons dashicons-info" style="color:#2563eb; margin-top:2px;"></span>
                        <div style="font-size:13px; color:#1e40af; line-height:1.6;">
                            <strong>SEO Tips:</strong>
                            <ul style="margin:8px 0 0 0; padding-left:20px;">
                                <li>Include your target keyword naturally in both title and description</li>
                                <li>Make your title compelling and click-worthy</li>
                                <li>Write descriptions that encourage users to click through</li>
                                <li>Avoid keyword stuffing - write for humans first</li>
                            </ul>
                        </div>
                    </div>
                </div>

                <div style="margin-top:16px; text-align:center;">
                    <button type="button" id="sekhlo-generate-meta-prompt" class="sekhlo-btn sekhlo-btn-ai" style="padding:12px 24px;">
                        <span class="dashicons dashicons-admin-generic"></span> Generate AI Prompt for Meta Tags
                    </button>
                    <p style="font-size:12px; color:#6b7280; margin-top:8px;">Get AI-generated semantic meta title, description, and slug suggestions</p>
                </div>
            </div>

            <div style="background:#ffffff; padding:20px; border-radius:8px; border:1px solid #e5e7eb; margin-bottom:20px;" id="sekhlo-meta-prompt-container" style="display:none;">
                <div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:16px;">
                    <h4 style="margin:0; color:#111827; font-size:16px;">Generated Meta Tags Prompt</h4>
                    <button type="button" id="sekhlo-copy-meta-prompt-btn" class="sekhlo-btn sekhlo-btn-primary">
                        <span class="dashicons dashicons-clipboard"></span> Copy Prompt
                    </button>
                </div>
                
                <textarea id="sekhlo-meta-prompt-textarea" readonly class="sekhlo-code-editor" style="min-height:350px; background:#f9fafb; cursor:text; font-size:13px; line-height:1.6;"></textarea>
                
                <div style="display:flex; gap:12px; margin-top:16px; align-items:center; flex-wrap:wrap;">
                    <span id="sekhlo-meta-copy-msg" style="color:#10b981; font-weight:600; font-size:13px;"></span>
                    <div style="margin-left:auto; display:flex; gap:8px; flex-wrap:wrap;">
                        <span style="font-size:13px; color:#6b7280; margin-right:8px;">Paste into:</span>
                        <a href="https://chatgpt.com" target="_blank" class="sekhlo-btn" style="text-decoration:none;">
                            <span class="dashicons dashicons-external"></span> ChatGPT
                        </a>
                        <a href="https://gemini.google.com" target="_blank" class="sekhlo-btn" style="text-decoration:none;">
                            <span class="dashicons dashicons-external"></span> Gemini
                        </a>
                        <a href="https://claude.ai" target="_blank" class="sekhlo-btn" style="text-decoration:none;">
                            <span class="dashicons dashicons-external"></span> Claude
                        </a>
                    </div>
                </div>
            </div>

            <div style="background:#ffffff; padding:20px; border-radius:8px; border:1px solid #e5e7eb;">
                <h4 style="margin-top:0; color:#111827; display:flex; align-items:center; gap:8px;">
                    <span class="dashicons dashicons-visibility" style="color:#10b981;"></span>
                    Search Result Preview
                </h4>
                <div id="sekhlo-meta-preview" style="padding:16px; background:#f9fafb; border-radius:6px; border:1px solid #e5e7eb;">
                    <div id="sekhlo-preview-url" style="font-size:12px; color:#5f6368; margin-bottom:4px;">
                        <?php echo esc_html(trailingslashit(home_url()) . ($post->post_name ?: sanitize_title(get_the_title($post->ID)))); ?>
                    </div>
                    <div style="font-size:20px; color:#1a0dab; margin-bottom:4px; font-weight:400; line-height:1.3;" id="sekhlo-preview-title">
                        <?php echo esc_html(get_post_meta($post->ID, 'sekhlo_seo_title', true) ?: get_the_title($post->ID)); ?>
                    </div>
                    <div style="font-size:14px; color:#4d5156; line-height:1.5;" id="sekhlo-preview-desc">
                        <?php 
                        $desc = get_post_meta($post->ID, 'sekhlo_seo_description', true);
                        echo esc_html($desc ?: 'Add a meta description to see how it appears in search results...');
                        ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- AI Prompt Generator Tab -->
        <div id="sekhlo_ai_prompt" class="sekhlo-tab-content">
            <div style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding:24px; border-radius:8px; margin-bottom:20px; color:#ffffff;">
                <h3 style="margin:0 0 12px 0; display:flex; align-items:center; gap:10px; color:#ffffff;">
                    <span class="dashicons dashicons-admin-generic" style="font-size:28px; width:28px; height:28px;"></span>
                    AI Schema Generator Prompt
                </h3>
                <p style="margin:0; font-size:14px; opacity:0.95;">
                    Copy this customized prompt and paste it into ChatGPT, Claude, or Gemini to generate optimized Schema.org JSON-LD code for this page.
                </p>
            </div>

            <div style="background:#ffffff; padding:24px; border-radius:8px; border:1px solid #e5e7eb; margin-bottom:20px;">
                <div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:16px;">
                    <h4 style="margin:0; color:#111827; font-size:16px;">Generated Prompt</h4>
                    <button type="button" id="sekhlo-copy-ai-prompt-btn" class="sekhlo-btn sekhlo-btn-primary">
                        <span class="dashicons dashicons-clipboard"></span> Copy Prompt
                    </button>
                </div>
                
                <textarea id="sekhlo-ai-prompt-textarea" readonly class="sekhlo-code-editor" style="min-height:450px; background:#f9fafb; cursor:text; font-size:13px; line-height:1.6;"></textarea>
                
                <div style="display:flex; gap:12px; margin-top:16px; align-items:center; flex-wrap:wrap;">
                    <span id="sekhlo-ai-copy-msg" style="color:#10b981; font-weight:600; font-size:13px;"></span>
                    <div style="margin-left:auto; display:flex; gap:8px; flex-wrap:wrap;">
                        <span style="font-size:13px; color:#6b7280; margin-right:8px;">Paste into:</span>
                        <a href="https://chatgpt.com" target="_blank" class="sekhlo-btn" style="text-decoration:none;">
                            <span class="dashicons dashicons-external"></span> ChatGPT
                        </a>
                        <a href="https://gemini.google.com" target="_blank" class="sekhlo-btn" style="text-decoration:none;">
                            <span class="dashicons dashicons-external"></span> Gemini
                        </a>
                        <a href="https://claude.ai" target="_blank" class="sekhlo-btn" style="text-decoration:none;">
                            <span class="dashicons dashicons-external"></span> Claude
                        </a>
                    </div>
                </div>
            </div>

            <div style="background:#eff6ff; padding:20px; border-radius:8px; border-left:4px solid #2563eb;">
                <h4 style="margin:0 0 12px 0; color:#1e40af; display:flex; align-items:center; gap:8px;">
                    <span class="dashicons dashicons-lightbulb" style="color:#2563eb;"></span>
                    How to Use
                </h4>
                <ol style="margin:0; padding-left:20px; color:#1e40af; line-height:1.8; font-size:14px;">
                    <li>Click the "Copy Prompt" button above</li>
                    <li>Open ChatGPT, Gemini, or Claude using the links provided</li>
                    <li>Paste the prompt into the AI chat</li>
                    <li>Wait for the AI to generate your schema code</li>
                    <li>Copy the generated JSON-LD code</li>
                    <li>Go back to the "Schemas" tab and paste it into the "Paste JSON-LD Code" field</li>
                    <li>Click "Add Schema" to save it</li>
                </ol>
            </div>
        </div>

        <!-- Templates Tab -->
        <div id="sekhlo_templates" class="sekhlo-tab-content">
            <div class="sekhlo-template-grid">
                <?php foreach ($templates as $key => $tpl): ?>
                <div class="sekhlo-template-card" data-key="<?php echo esc_attr($key); ?>">
                    <span class="sekhlo-template-icon"><span class="dashicons dashicons-layout"></span></span>
                    <span class="sekhlo-template-name"><?php echo esc_html($tpl['label']); ?></span>
                    <span class="sekhlo-template-desc"><?php echo esc_html($tpl['description']); ?></span>
                </div>
                <?php endforeach; ?>
            </div>
        </div>

        <div id="sekhlo_preview" class="sekhlo-tab-content">
            <div class="sekhlo-preview-section">
                <p class="sekhlo-section-title" style="font-weight:600; color:#111827; margin-bottom:12px;">Google Search Preview</p>
                <div class="sekhlo-preview-container" id="sekhlo-preview-content">
                    <!-- JS renders SERP preview here -->
                </div>
            </div>

            <div class="sekhlo-preview-section" style="margin-top:30px;">
                <p class="sekhlo-section-title" style="font-weight:600; color:#111827; margin-bottom:12px;">Generated JSON-LD Code</p>
                <div class="sekhlo-raw-code-container" style="background:#ffffff; border:1px solid #e5e7eb; border-radius:8px; padding:16px;">
                    <textarea id="sekhlo-raw-json-output" class="sekhlo-editor" readonly style="min-height:200px; background:#f9fafb; width:100%; border:1px solid #e5e7eb; border-radius:6px; padding:14px; font-family:monospace; font-size:13px;"></textarea>
                    <div style="display:flex; justify-content:space-between; align-items:center; margin-top:12px; flex-wrap:wrap; gap:12px;">
                        <button type="button" id="sekhlo-copy-raw-btn" class="sekhlo-btn sekhlo-btn-purple">
                            <span class="dashicons dashicons-clipboard"></span> Copy Code
                        </button>
                        <span id="sekhlo-copy-msg" class="sekhlo-msg" style="color:#10b981; font-weight:500;"></span>
                        <div style="font-size:12px; color:#6b7280;">
                            Test with <a href="https://search.google.com/test/rich-results" target="_blank" style="color:#2563eb; text-decoration:none; font-weight:600;">Google Rich Results</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Testing Tab -->
        <div id="sekhlo_testing" class="sekhlo-tab-content">
            <p style="color:#6b7280; margin-bottom:20px;">Validate your schema markup with official testing tools:</p>
            
            <div style="display:flex; gap:12px; margin-bottom:30px; flex-wrap:wrap;">
                <a href="https://search.google.com/test/rich-results?url=<?php echo urlencode(get_permalink($post->ID)); ?>" target="_blank" class="sekhlo-btn sekhlo-btn-primary">
                    <span class="dashicons dashicons-google"></span> Google Rich Results
                </a>
                
                <a href="https://validator.schema.org/" target="_blank" class="sekhlo-btn">
                    <span class="dashicons dashicons-yes-alt"></span> Schema.org Validator
                </a>
            </div>

            <div style="background:#eff6ff; padding:24px; border-radius:8px; border:1px solid #bfdbfe;">
                <div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:12px;">
                    <h4 style="margin:0; color:#1e40af;">AI Optimization Score</h4>
                    <span class="sekhlo-score-value" style="font-size:32px; font-weight:700; color:#2563eb;"><span id="sekhlo-score-num">0</span>%</span>
                </div>
                <div class="sekhlo-score-meter" style="height:8px; background:#dbeafe; border-radius:4px; overflow:hidden; margin-bottom:12px;">
                    <div class="sekhlo-score-fill" id="sekhlo-score-fill" style="height:100%; width:0%; background:#2563eb; transition:width 0.5s ease;"></div>
                </div>
                <p id="sekhlo-score-feedback" style="margin:0 0 16px 0; color:#1e40af; font-weight:500;">Add schemas to evaluate your optimization score.</p>
                <ul id="sekhlo-score-tips" style="font-size:12px; color:#3b82f6; margin:0; padding-left:20px; line-height:1.8;">
                    <li>Use Article schema for knowledge graph entry</li>
                    <li>Add FAQ schema for voice search optimization</li>
                </ul>
            </div>
        </div>

    </div>
</div>
