<?php
/**
 * Schema Templates Library
 *
 * Contains pre-built JSON-LD templates for standard SEQ and AI/GEO optimization.
 */

if (!defined('ABSPATH')) {
    exit;
}

class Sekhlo_Schema_Templates {

    /**
     * Get all available templates.
     *
     * @return array List of templates.
     */
    public static function get_templates() {
        return array(
            'article' => array(
                'label' => 'Article / News',
                'description' => 'For blog posts and news articles. Great for features in Google Discover.',
                'code' => self::get_article_template()
            ),
            'faq' => array(
                'label' => 'FAQ Page',
                'description' => 'For Frequently Asked Questions. Eligible for rich results.',
                'code' => self::get_faq_template()
            ),
            'product' => array(
                'label' => 'Product',
                'description' => 'For e-commerce product pages. Displays price, rating, and availability.',
                'code' => self::get_product_template()
            ),
            'recipe' => array(
                'label' => 'Recipe',
                'description' => 'For culinary recipes. Shows simplified instructions, cook time, and calories.',
                'code' => self::get_recipe_template()
            ),
            'howto' => array(
                'label' => 'HowTo',
                'description' => 'For step-by-step guides. Helps AI understand instructions.',
                'code' => self::get_howto_template()
            ),
            'local_business' => array(
                'label' => 'Local Business',
                'description' => 'Essential for Local SEO and Maps visibility.',
                'code' => self::get_local_business_template()
            ),
            'event' => array(
                'label' => 'Event',
                'description' => 'For concerts, webinars, and scheduled events.',
                'code' => self::get_event_template()
            ),
            'organization' => array(
                'label' => 'Organization',
                'description' => 'Establish brand identity in Knowledge Graphs.',
                'code' => self::get_organization_template()
            ),
            // AI / GEO Optimized Templates
            'speakable' => array(
                'label' => 'Speakable (Voice Search)',
                'description' => 'Optimized for Google Assistant and voice answers.',
                'code' => self::get_speakable_template()
            ),
            'video' => array(
                'label' => 'Video Object',
                'description' => 'For video content SEO and AI summaries.',
                'code' => self::get_video_template()
            ),
            'course' => array(
                'label' => 'Course',
                'description' => 'For educational courses and learning paths.',
                'code' => self::get_course_template()
            ),
            'cams' => array(
                'label' => 'Claims Review (Fact Check)',
                'description' => 'Builds trust for AI verification.',
                'code' => self::get_claim_review_template()
            ),
            'software' => array(
                'label' => 'Software Application',
                'description' => 'For apps, plugins, and software tools.',
                'code' => self::get_software_template()
            ),
            'job' => array(
                'label' => 'Job Posting',
                'description' => 'For job listings.',
                'code' => self::get_job_posting_template()
            ),
             'breadcrumb' => array(
                'label' => 'BreadcrumbList',
                'description' => 'Helps AI understand site structure.',
                'code' => self::get_breadcrumb_template()
            ),
        );
    }

    private static function get_article_template() {
        return json_encode(array(
            '@context' => 'https://schema.org',
            '@type' => 'Article',
            'headline' => '%title%',
            'image' => array('%featured_image%'),
            'datePublished' => '%date_published%',
            'dateModified' => '%date_modified%',
            'author' => array(
                '@type' => 'Person',
                'name' => '%author_name%',
                'url' => '%author_url%'
            ),
            'publisher' => array(
                '@type' => 'Organization',
                'name' => '%site_title%',
                'logo' => array(
                    '@type' => 'ImageObject',
                    'url' => '%site_logo%'
                )
            ),
            'mainEntityOfPage' => array(
                '@type' => 'WebPage',
                '@id' => '%post_url%'
            ),
            'about' => array(
                '@type' => 'Thing',
                'name' => 'Main Topic',
                'sameAs' => 'https://en.wikipedia.org/wiki/Topic'
            ),
            'mentions' => array(
                array(
                    '@type' => 'Thing', 
                    'name' => 'Related Entity',
                    'sameAs' => 'https://en.wikipedia.org/wiki/Related'
                )
            )
        ), JSON_PRETTY_PRINT);
    }

    private static function get_faq_template() {
        return json_encode(array(
            '@context' => 'https://schema.org',
            '@type' => 'FAQPage',
            'mainEntity' => array(
                array(
                    '@type' => 'Question',
                    'name' => 'Insert Question 1 here?',
                    'acceptedAnswer' => array(
                        '@type' => 'Answer',
                        'text' => 'Insert Answer 1 here.'
                    )
                ),
                array(
                    '@type' => 'Question',
                    'name' => 'Insert Question 2 here?',
                    'acceptedAnswer' => array(
                        '@type' => 'Answer',
                        'text' => 'Insert Answer 2 here.'
                    )
                )
            )
        ), JSON_PRETTY_PRINT);
    }

    private static function get_product_template() {
        return json_encode(array(
            '@context' => 'https://schema.org',
            '@type' => 'Product',
            'name' => '%title%',
            'image' => '%featured_image%',
            'description' => '%excerpt%',
            'brand' => array(
                '@type' => 'Brand',
                'name' => 'Brand Name'
            ),
            'sku' => 'SKU12345',
            'offers' => array(
                '@type' => 'Offer',
                'url' => '%post_url%',
                'priceCurrency' => 'USD',
                'price' => '99.99',
                'priceValidUntil' => '2026-12-31',
                'itemCondition' => 'https://schema.org/NewCondition',
                'availability' => 'https://schema.org/InStock',
                'seller' => array(
                    '@type' => 'Organization',
                    'name' => '%site_title%'
                )
            ),
            'aggregateRating' => array(
                '@type' => 'AggregateRating',
                'ratingValue' => '4.5',
                'reviewCount' => '24'
            )
        ), JSON_PRETTY_PRINT);
    }

    private static function get_recipe_template() {
        return json_encode(array(
            '@context' => 'https://schema.org',
            '@type' => 'Recipe',
            'name' => '%title%',
            'image' => array('%featured_image%'),
            'author' => array(
                 '@type' => 'Person',
                 'name' => '%author_name%'
            ),
            'datePublished' => '%date_published%',
            'description' => '%excerpt%',
            'prepTime' => 'PT20M',
            'cookTime' => 'PT30M',
            'totalTime' => 'PT50M',
            'keywords' => 'keyword1, keyword2',
            'recipeYield' => '4 servings',
            'recipeCategory' => 'Main Course',
            'recipeCuisine' => 'American',
            'nutrition' => array(
                '@type' => 'NutritionInformation',
                'calories' => '240 calories'
            ),
            'recipeIngredient' => array(
                '2 cups flour',
                '1 tsp baking powder'
            ),
            'recipeInstructions' => array(
                array(
                    '@type' => 'HowToStep',
                    'name' => 'Step 1',
                    'text' => 'Mix ingredients together.'
                ),
                array(
                    '@type' => 'HowToStep',
                    'name' => 'Step 2',
                    'text' => 'Bake at 350 degrees.'
                )
            )
        ), JSON_PRETTY_PRINT);
    }

    private static function get_howto_template() {
        return json_encode(array(
            '@context' => 'https://schema.org',
            '@type' => 'HowTo',
            'name' => '%title%',
            'description' => '%excerpt%',
            'step' => array(
                array(
                    '@type' => 'HowToStep',
                    'name' => 'Step 1',
                    'text' => 'First step description',
                    'url' => '%post_url%#step1'
                ),
                array(
                    '@type' => 'HowToStep',
                    'name' => 'Step 2',
                    'text' => 'Second step description',
                    'url' => '%post_url%#step2'
                )
            ),
            'supply' => array(
                array(
                    '@type' => 'HowToSupply',
                    'name' => 'Supply 1'
                )
            ),
            'tool' => array(
                array(
                    '@type' => 'HowToTool',
                    'name' => 'Tool 1'
                )
            )
        ), JSON_PRETTY_PRINT);
    }

    private static function get_local_business_template() {
        return json_encode(array(
            '@context' => 'https://schema.org',
            '@type' => 'LocalBusiness',
            'name' => 'Business Name',
            'image' => '%featured_image%',
            '@id' => '%site_url%#localbusiness',
            'url' => '%site_url%',
            'telephone' => '+15551234567',
            'priceRange' => '$$',
            'address' => array(
                '@type' => 'PostalAddress',
                'streetAddress' => '123 Main St',
                'addressLocality' => 'City Name',
                'addressRegion' => 'CA',
                'postalCode' => '90001',
                'addressCountry' => 'US'
            ),
            'geo' => array(
                '@type' => 'GeoCoordinates',
                'latitude' => 34.052235,
                'longitude' => -118.243683
            ),
            'openingHoursSpecification' => array(
                array(
                    '@type' => 'OpeningHoursSpecification',
                    'dayOfWeek' => array('Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday'),
                    'opens' => '09:00',
                    'closes' => '17:00'
                )
            )
        ), JSON_PRETTY_PRINT);
    }
    
    private static function get_event_template() {
        return json_encode(array(
            '@context' => 'https://schema.org',
            '@type' => 'Event',
            'name' => 'Event Title',
            'startDate' => '2026-07-21T19:00',
            'endDate' => '2026-07-21T23:00',
            'eventStatus' => 'https://schema.org/EventScheduled',
            'eventAttendanceMode' => 'https://schema.org/OfflineEventAttendanceMode',
            'location' => array(
                '@type' => 'Place',
                'name' => 'Venue Name',
                'address' => array(
                    '@type' => 'PostalAddress',
                    'streetAddress' => 'Venue Address',
                    'addressLocality' => 'City',
                    'postalCode' => 'Zip',
                    'addressCountry' => 'US'
                )
            ),
            'image' => array('%featured_image%'),
            'description' => 'Event description here.',
            'organizer' => array(
                '@type' => 'Organization',
                'name' => '%site_title%',
                'url' => '%site_url%'
            )
        ), JSON_PRETTY_PRINT);
    }

    private static function get_organization_template() {
        return json_encode(array(
            '@context' => 'https://schema.org',
            '@type' => 'Organization',
            'name' => '%site_title%',
            'url' => '%site_url%',
            'logo' => '%site_logo%',
            'sameAs' => array(
                'https://www.facebook.com/yourbrand',
                'https://twitter.com/yourbrand',
                'https://www.instagram.com/yourbrand'
            ),
            'contactPoint' => array(
                '@type' => 'ContactPoint',
                'telephone' => '+1-800-555-5555',
                'contactType' => 'Customer Service'
            )
        ), JSON_PRETTY_PRINT);
    }

    private static function get_speakable_template() {
        return json_encode(array(
            '@context' => 'https://schema.org',
            '@type' => 'WebPage',
            'speakable' => array(
                '@type' => 'SpeakableSpecification',
                'cssSelector' => array(
                    '.speakable-summary',
                    '#key-takeaways'
                )
            )
        ), JSON_PRETTY_PRINT);
    }

    private static function get_video_template() {
        return json_encode(array(
            '@context' => 'https://schema.org',
            '@type' => 'VideoObject',
            'name' => 'Video Title',
            'description' => 'Video description',
            'thumbnailUrl' => array('thumbnail-url.jpg'),
            'uploadDate' => '%date_published%',
            'duration' => 'PT1M30S',
            'contentUrl' => 'https://www.example.com/video123.mp4',
            'embedUrl' => 'https://www.example.com/embed/123',
            'publisher' => array(
                '@type' => 'Organization',
                'name' => '%site_title%',
                'logo' => array(
                    '@type' => 'ImageObject',
                    'url' => '%site_logo%'
                )
            )
        ), JSON_PRETTY_PRINT);
    }

    private static function get_course_template() {
        return json_encode(array(
             '@context' => 'https://schema.org',
             '@type' => 'Course',
             'name' => 'Course Name',
             'description' => 'Course description.',
             'provider' => array(
                 '@type' => 'Organization',
                 'name' => '%site_title%',
                 'sameAs' => '%site_url%'
             )
        ), JSON_PRETTY_PRINT);
    }

    private static function get_claim_review_template() {
        return json_encode(array(
            '@context' => 'https://schema.org',
            '@type' => 'ClaimReview',
            'datePublished' => '%date_published%',
            'url' => '%post_url%',
            'itemReviewed' => array(
                '@type' => 'Claim',
                'author' => array(
                    '@type' => 'Person',
                    'name' => 'Person who made the claim'
                ),
                'datePublished' => '2026-01-01',
                'appearance' => array(
                    array(
                        '@type' => 'CreativeWork',
                         'url' => 'https://example.com/source-article'
                    )
                )
            ),
            'claimReviewed' => 'The claim text being reviewed.',
            'author' => array(
                '@type' => 'Organization',
                'name' => '%site_title%'
            ),
            'reviewRating' => array(
                '@type' => 'Rating',
                'ratingValue' => '5',
                'bestRating' => '5',
                'worstRating' => '1',
                'alternateName' => 'True'
            )
        ), JSON_PRETTY_PRINT);
    }

    private static function get_software_template() {
        return json_encode(array(
            '@context' => 'https://schema.org',
            '@type' => 'SoftwareApplication',
            'name' => 'Application Name',
            'operatingSystem' => 'Windows, macOS, Android, iOS',
            'applicationCategory' => 'ProductivityApplication',
            'offers' => array(
                '@type' => 'Offer',
                'price' => '0.00',
                'priceCurrency' => 'USD'
            )
        ), JSON_PRETTY_PRINT);
    }
    
    private static function get_job_posting_template() {
         return json_encode(array(
            '@context' => 'https://schema.org',
            '@type' => 'JobPosting',
            'title' => 'Job Title',
            'description' => '<p>Job definition and requirements...</p>',
            'datePosted' => '%date_published%',
            'validThrough' => '2026-12-31',
            'employmentType' => 'FULL_TIME',
            'hiringOrganization' => array(
                '@type' => 'Organization',
                'name' => '%site_title%',
                'sameAs' => '%site_url%'
            ),
            'jobLocation' => array(
                '@type' => 'Place',
                'address' => array(
                    '@type' => 'PostalAddress',
                    'streetAddress' => '123 Street',
                    'addressLocality' => 'City',
                    'postalCode' => '90000',
                    'addressCountry' => 'US'
                )
            )
        ), JSON_PRETTY_PRINT);
    }

    private static function get_breadcrumb_template() {
        return json_encode(array(
            '@context' => 'https://schema.org',
            '@type' => 'BreadcrumbList',
            'itemListElement' => array(
                array(
                    '@type' => 'ListItem',
                    'position' => 1,
                    'name' => 'Home',
                    'item' => '%site_url%'
                ),
                array(
                    '@type' => 'ListItem',
                    'position' => 2,
                    'name' => '%title%',
                    'item' => '%post_url%'
                )
            )
        ), JSON_PRETTY_PRINT);
    }
}
